/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.config.TelemetryConfigurationFactory;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.HashSet;

public final class ConfigurationFileLocator {
    private final String configurationFileName;

    public ConfigurationFileLocator(String configurationFileName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)configurationFileName) ? 1 : 0) != 0, (Object)"configurationFile should be non-null non empty value");
        this.configurationFileName = configurationFileName;
    }

    public InputStream getConfigurationFile() {
        InputStream inputStream = ConfigurationFileLocator.class.getClassLoader().getResourceAsStream(this.configurationFileName);
        if (inputStream != null) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.INFO, "Configuration file has been successfully found as resource", new Object[0]);
            return inputStream;
        }
        String configurationFile = this.getConfigurationFromCurrentClassLoader();
        if (configurationFile == null && (configurationFile = this.getConfigurationFromLibraryLocation()) == null) {
            configurationFile = this.getConfFromClassPath();
        }
        if (configurationFile != null) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.INFO, "Configuration file has been successfully found in: '%s'", configurationFile);
            try {
                return new FileInputStream(configurationFile);
            }
            catch (FileNotFoundException e) {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.WARN, "Configuration file '%s' could not be opened for reading", configurationFile);
            }
        } else {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.WARN, "Configuration file '%s' could not be found", this.configurationFileName);
        }
        return null;
    }

    private static void logException(Throwable t, String message) {
        if (t.getCause() != null) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.WARN, "Failed to find configuration file, exception while fetching from %s: '%s'", message, t.getCause().getMessage());
        } else {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.WARN, "Failed to find configuration file, exception while fetching from %s: '%s'", message, t.getMessage());
        }
    }

    private String getConfigurationFromCurrentClassLoader() {
        try {
            File filePath;
            ClassLoader classLoader = ConfigurationFileLocator.class.getClassLoader();
            String configurationFile = null;
            URL resourceUrl = classLoader.getResource(this.configurationFileName);
            if (resourceUrl != null && (filePath = this.normalizeUrlToFile(resourceUrl)) != null) {
                configurationFile = filePath.toString();
            }
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.INFO, "Configuration file '%s' was %sfound by default class loader", this.configurationFileName, configurationFile == null ? "NOT " : "");
            return configurationFile;
        }
        catch (Throwable t) {
            ConfigurationFileLocator.logException(t, "current class loader");
            return null;
        }
    }

    private String getConfigurationFromLibraryLocation() {
        try {
            CodeSource codeSource = ConfigurationFileLocator.class.getProtectionDomain().getCodeSource();
            if (codeSource == null) {
                return null;
            }
            String jarFullPath = codeSource.getLocation().toURI().getPath();
            File jarFile = new File(jarFullPath);
            if (jarFile.exists()) {
                String jarDirectory = jarFile.getParent();
                String configurationPath = this.getConfigurationAbsolutePath(jarDirectory);
                if (configurationPath != null) {
                    return configurationPath;
                }
            } else {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.WARN, "Can not access folder '%s'", jarFullPath);
            }
        }
        catch (Throwable t) {
            ConfigurationFileLocator.logException(t, "library location");
        }
        return null;
    }

    private String getConfFromClassPath() {
        try {
            URL[] urls;
            ClassLoader classLoader = TelemetryConfigurationFactory.class.getClassLoader();
            if (!(classLoader instanceof URLClassLoader)) {
                return null;
            }
            HashSet<String> checkedUrls = new HashSet<String>();
            for (URL url : urls = ((URLClassLoader)classLoader).getURLs()) {
                String configurationPath;
                File filePath = this.normalizeUrlToFile(url);
                if (filePath == null) continue;
                if (filePath.isFile()) {
                    filePath = filePath.getParentFile();
                }
                if (checkedUrls.contains(configurationPath = filePath.toString())) continue;
                String configurationFile = this.getConfigurationAbsolutePath(configurationPath);
                if (configurationFile != null) {
                    return configurationFile;
                }
                checkedUrls.add(configurationPath);
            }
        }
        catch (Throwable t) {
            ConfigurationFileLocator.logException(t, "class path");
        }
        return null;
    }

    private String getConfigurationAbsolutePath(String path) {
        File configFile = new File(path, this.configurationFileName);
        if (configFile.exists()) {
            return configFile.getAbsolutePath();
        }
        InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.INFO, "Did not find configuration file '%s' in '%s'", this.configurationFileName, path);
        return null;
    }

    private File normalizeUrlToFile(URL url) {
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.INFO, "Failed to convert URL '%s' to URI ", url);
            return null;
        }
        return new File(uri.getSchemeSpecificPart());
    }
}

