/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.internal.channel.TransmissionDispatcher;
import com.microsoft.applicationinsights.internal.channel.TransmissionsLoader;
import com.microsoft.applicationinsights.internal.channel.common.Transmission;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionFileSystemOutput;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ActiveTransmissionLoader
implements TransmissionsLoader {
    public static final int MAX_THREADS_ALLOWED = 10;
    private static final int DEFAULT_NUMBER_OF_THREADS = 1;
    private static final long DEFAULT_SLEEP_INTERVAL_WHEN_NO_TRANSMISSIONS_FOUND_IN_MILLS = 2000L;
    private static final long DEFAULT_SLEEP_INTERVAL_AFTER_DISPATCHING_IN_MILLS = 100L;
    private final TransmissionFileSystemOutput fileSystem;
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final TransmissionDispatcher dispatcher;
    private CyclicBarrier barrier;
    private final Thread[] threads;
    private final long sleepIntervalWhenNoTransmissionsFoundInMills;

    public ActiveTransmissionLoader(TransmissionFileSystemOutput fileSystem, TransmissionDispatcher dispatcher) {
        this(fileSystem, dispatcher, 1);
    }

    public ActiveTransmissionLoader(final TransmissionFileSystemOutput fileSystem, final TransmissionDispatcher dispatcher, int numberOfThreads) {
        Preconditions.checkNotNull((Object)fileSystem, (Object)"fileSystem must be a non-null value");
        Preconditions.checkNotNull((Object)dispatcher, (Object)"dispatcher must be a non-null value");
        Preconditions.checkArgument((numberOfThreads > 0 ? 1 : 0) != 0, (Object)"numberOfThreads must be a positive number");
        Preconditions.checkArgument((numberOfThreads < 10 ? 1 : 0) != 0, (String)"numberOfThreads must be smaller than %s", (Object[])new Object[]{10});
        this.sleepIntervalWhenNoTransmissionsFoundInMills = 2000L;
        this.fileSystem = fileSystem;
        this.dispatcher = dispatcher;
        this.threads = new Thread[numberOfThreads];
        for (int i = 0; i < numberOfThreads; ++i) {
            this.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ActiveTransmissionLoader.this.barrier.await();
                    }
                    catch (InterruptedException e) {
                        InternalLogger.INSTANCE.error("Interrupted during barrier wait, exception: %s", e.getMessage());
                    }
                    catch (BrokenBarrierException e) {
                        InternalLogger.INSTANCE.error("Failed during barrier wait, exception: %s", e.getMessage());
                    }
                    while (!ActiveTransmissionLoader.this.done.get()) {
                        try {
                            Transmission transmission = fileSystem.fetchOldestFile();
                            if (transmission == null) {
                                Thread.sleep(ActiveTransmissionLoader.this.sleepIntervalWhenNoTransmissionsFoundInMills);
                                continue;
                            }
                            dispatcher.dispatch(transmission);
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                        }
                        catch (Throwable throwable) {}
                    }
                }
            });
            this.threads[i].setDaemon(true);
        }
    }

    @Override
    public synchronized boolean load(boolean waitForThreadsToStart) {
        if (this.barrier == null) {
            int numberOfThreads = this.threads.length;
            if (waitForThreadsToStart) {
                ++numberOfThreads;
            }
            this.barrier = new CyclicBarrier(numberOfThreads);
        }
        for (Thread thread : this.threads) {
            thread.start();
        }
        try {
            this.barrier.await();
            return true;
        }
        catch (InterruptedException e) {
            InternalLogger.INSTANCE.error("Interrupted during barrier wait, exception: %s", e.getMessage());
        }
        catch (BrokenBarrierException e) {
            InternalLogger.INSTANCE.error("Failed during barrier wait, exception: %s", e.getMessage());
        }
        return false;
    }

    @Override
    public void stop(long timeout, TimeUnit timeUnit) {
        this.done.set(true);
        for (Thread thread : this.threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                InternalLogger.INSTANCE.error("Interrupted during join of active transmission loader, exception: %s", e.getMessage());
            }
        }
    }
}

