/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.util;

import com.google.common.base.Strings;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class Sanitizer {
    public static final int MAX_MAP_NAME_LENGTH = 150;
    public static final int MAX_VALUE_LENGTH = 1024;
    public static final int MAX_NAME_LENGTH = 1024;
    public static final int MAX_MESSAGE_LENGTH = 32768;
    public static final int MAX_URL_LENGTH = 2048;
    private static final String INVALID_NAME_CHARACTERS = "[^0-9a-zA-Z-._()\\/ ]";

    public static void sanitizeProperties(Map<String, String> map) {
        if (map != null) {
            HashMap<String, String> tempMap = new HashMap<String, String>(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String sanitizedKey = Sanitizer.sanitizeKey(entry.getKey(), tempMap);
                String sanitizedValue = Sanitizer.sanitizeValue(entry.getValue());
                tempMap.put(sanitizedKey, sanitizedValue);
            }
            map.clear();
            map.putAll(tempMap);
        }
    }

    public static void sanitizeMeasurements(Map<String, Double> map) {
        if (map != null) {
            HashMap<String, Double> tempMap = new HashMap<String, Double>(map.size());
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                String sanitizedKey = Sanitizer.sanitizeKey(entry.getKey(), tempMap);
                tempMap.put(sanitizedKey, entry.getValue());
            }
            map.clear();
            map.putAll(tempMap);
        }
    }

    public static URI sanitizeUri(String urlAsString) {
        if (!Strings.isNullOrEmpty((String)urlAsString)) {
            if (urlAsString.length() > 2048) {
                urlAsString = urlAsString.substring(0, 2048);
            }
            URI temp = null;
            try {
                temp = new URI(urlAsString);
                return temp;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String sanitizeValue(String value) {
        return Sanitizer.trimAndTruncate(value, 1024);
    }

    public static String sanitizeName(String name) {
        return Sanitizer.trimAndTruncate(name, 1024);
    }

    public static String sanitizeMessage(String message) {
        return Sanitizer.trimAndTruncate(message, 32768);
    }

    public static boolean isUUID(String possibleUUID) {
        try {
            UUID.fromString(possibleUUID);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static URI safeStringToUri(String url) {
        if (Strings.isNullOrEmpty((String)url)) {
            return null;
        }
        URI result = null;
        try {
            result = new URI(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static <V> String sanitizeKey(String key, Map<String, V> map) {
        String sanitizedKey = Sanitizer.trimAndTruncate(key, 150);
        sanitizedKey = sanitizedKey.replaceAll(INVALID_NAME_CHARACTERS, "");
        sanitizedKey = Sanitizer.MakeKeyNonEmpty(sanitizedKey);
        sanitizedKey = Sanitizer.MakeKeyUnique(sanitizedKey, map);
        return sanitizedKey;
    }

    private static String trimAndTruncate(String value, int maxLength) {
        if (value == null) {
            return value;
        }
        String sanitized = value.trim();
        if (sanitized.length() > maxLength) {
            sanitized = sanitized.substring(0, maxLength);
        }
        return sanitized;
    }

    private static String MakeKeyNonEmpty(String key) {
        return Strings.isNullOrEmpty((String)key) ? "(required property name is empty)" : key;
    }

    private static <V> String MakeKeyUnique(String key, Map<String, V> map) {
        if (map.containsKey(key)) {
            int uniqueNumberLength = 3;
            String truncatedKey = Sanitizer.truncate(key, 150 - uniqueNumberLength);
            int candidate = 1;
            do {
                key = truncatedKey + String.format("%0%dd", uniqueNumberLength, candidate);
                ++candidate;
            } while (map.containsKey(key));
        }
        return key;
    }

    private static String truncate(String value, int maxLength) {
        return value.length() > maxLength ? value.substring(0, maxLength) : value;
    }
}

