/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.schemav2;

import com.microsoft.applicationinsights.internal.schemav2.Domain;
import com.microsoft.applicationinsights.telemetry.Duration;
import com.microsoft.applicationinsights.telemetry.JsonTelemetryDataSerializer;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RequestData
extends Domain {
    public static final String REQUEST_ENVELOPE_NAME = "Microsoft.ApplicationInsights.Request";
    public static final String REQUEST_BASE_TYPE = "Microsoft.ApplicationInsights.RequestData";
    private int ver = 2;
    private String id;
    private String name;
    private Date startTime;
    private Duration duration;
    private String responseCode;
    private boolean success;
    private String httpMethod;
    private String url;
    private ConcurrentMap<String, String> properties;
    private ConcurrentMap<String, Double> measurements;

    public RequestData() {
        this.InitializeFields();
    }

    public int getVer() {
        return this.ver;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date value) {
        this.startTime = value;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration value) {
        this.duration = value;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(String value) {
        this.responseCode = value;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean value) {
        this.success = value;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String value) {
        this.httpMethod = value;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String value) {
        this.url = value;
    }

    public ConcurrentMap<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, String>();
        }
        return this.properties;
    }

    public void setProperties(ConcurrentMap<String, String> value) {
        this.properties = value;
    }

    public ConcurrentMap<String, Double> getMeasurements() {
        if (this.measurements == null) {
            this.measurements = new ConcurrentHashMap<String, Double>();
        }
        return this.measurements;
    }

    public void setMeasurements(ConcurrentMap<String, Double> value) {
        this.measurements = value;
    }

    @Override
    public String getEnvelopName() {
        return REQUEST_ENVELOPE_NAME;
    }

    @Override
    public String getBaseTypeName() {
        return REQUEST_BASE_TYPE;
    }

    @Override
    protected void serializeContent(JsonTelemetryDataSerializer writer) throws IOException {
        super.serializeContent(writer);
        writer.write("ver", this.ver);
        writer.write("id", this.id);
        writer.write("name", this.name);
        writer.write("startTime", this.startTime);
        writer.write("duration", this.duration != null ? this.duration.toString() : "");
        writer.write("responseCode", this.responseCode);
        writer.write("success", this.success);
        writer.write("httpMethod", this.httpMethod);
        writer.write("url", this.url);
        writer.write("properties", this.properties);
        writer.write("measurements", this.measurements);
    }

    @Override
    protected void InitializeFields() {
    }
}

