/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounter;
import com.microsoft.applicationinsights.internal.shutdown.SDKShutdownActivity;
import com.microsoft.applicationinsights.internal.shutdown.Stoppable;
import com.microsoft.applicationinsights.internal.util.ThreadPoolUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public enum PerformanceCounterContainer implements Stoppable
{
    INSTANCE;

    private static final long START_COLLECTING_DELAY_IN_MILLIS = 60000L;
    private static final long START_DEFAULT_MIN_DELAY_IN_MILLIS = 20000L;
    private static final long COLLECTING_INTERVAL_IN_MILLIS = 40000L;
    private static final long COLLECTING_DEFAULT_MIN_INTERVAL_IN_MILLIS = 20000L;
    private final ConcurrentMap<String, PerformanceCounter> performanceCounters = new ConcurrentHashMap<String, PerformanceCounter>();
    private volatile boolean initialized = false;
    private long startCollectingDelayInMillis = 60000L;
    private long collectingIntervalInMillis = 40000L;
    private TelemetryClient telemetryClient;
    private ScheduledThreadPoolExecutor threads;

    public boolean register(PerformanceCounter performanceCounter) {
        Preconditions.checkNotNull((Object)performanceCounter, (Object)"performanceCounter should be non null, non empty value");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)performanceCounter.getId()) ? 1 : 0) != 0, (Object)"performanceCounter's id should be non null, non empty value");
        this.initialize();
        InternalLogger.INSTANCE.trace("Registering PC '%s'", performanceCounter.getId());
        PerformanceCounter prev = this.performanceCounters.putIfAbsent(performanceCounter.getId(), performanceCounter);
        if (prev != null) {
            InternalLogger.INSTANCE.trace("Failed to store performance counter '%s', since there is already one", performanceCounter.getId());
            return false;
        }
        return true;
    }

    public void unregister(PerformanceCounter performanceCounter) {
        this.unregister(performanceCounter.getId());
    }

    public void unregister(String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"id should be non null, non empty value");
        InternalLogger.INSTANCE.trace("Un-registering PC '%s'", id);
        this.performanceCounters.remove(id);
    }

    public long getStartCollectingDelayInMillis() {
        return this.startCollectingDelayInMillis;
    }

    public long getCollectingIntervalInMillis() {
        return this.collectingIntervalInMillis;
    }

    @Override
    public synchronized void stop(long timeout, TimeUnit timeUnit) {
        if (!this.initialized) {
            return;
        }
        ThreadPoolUtils.stop(this.threads, timeout, timeUnit);
        this.initialized = false;
    }

    void setStartCollectingDelayInMillis(long startCollectingDelayInMillis) {
        if (startCollectingDelayInMillis < 20000L) {
            InternalLogger.INSTANCE.error("Start Collecting Delay: illegal value '%d'. The minimum value, '%'d, is used instead.", startCollectingDelayInMillis, 20000L);
            startCollectingDelayInMillis = 20000L;
        }
        this.startCollectingDelayInMillis = startCollectingDelayInMillis;
    }

    void setCollectingIntervalInMillis(long collectingIntervalInMillis) {
        if (collectingIntervalInMillis <= 20000L) {
            InternalLogger.INSTANCE.error("Collecting Interval: illegal value '%d'. The minimum value, '%'d, is used instead.", collectingIntervalInMillis, 20000L);
            collectingIntervalInMillis = 20000L;
        }
        this.collectingIntervalInMillis = collectingIntervalInMillis;
    }

    void clear() {
        this.performanceCounters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (!this.initialized) {
            PerformanceCounterContainer performanceCounterContainer = INSTANCE;
            synchronized (performanceCounterContainer) {
                if (!this.initialized) {
                    this.createThreadToCollect();
                    this.scheduleWork();
                    this.initialized = true;
                }
            }
        }
    }

    private void scheduleWork() {
        this.threads.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (PerformanceCounterContainer.this.telemetryClient == null) {
                    PerformanceCounterContainer.this.telemetryClient = new TelemetryClient();
                }
                for (PerformanceCounter performanceCounter : PerformanceCounterContainer.this.performanceCounters.values()) {
                    try {
                        performanceCounter.report(PerformanceCounterContainer.this.telemetryClient);
                    }
                    catch (Throwable e) {
                        InternalLogger.INSTANCE.error("Exception while reporting performance counter '%s': '%s'", performanceCounter.getId(), e.getMessage());
                    }
                }
            }
        }, this.startCollectingDelayInMillis, this.collectingIntervalInMillis, TimeUnit.MILLISECONDS);
        SDKShutdownActivity.INSTANCE.register(INSTANCE);
    }

    private void createThreadToCollect() {
        this.threads = new ScheduledThreadPoolExecutor(1);
        this.threads.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                return thread;
            }
        });
    }
}

