/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.internal.jmx.JmxAttributeData;
import com.microsoft.applicationinsights.internal.jmx.JmxDataFetcher;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounter;
import com.microsoft.applicationinsights.internal.system.SystemInformation;
import com.microsoft.applicationinsights.telemetry.PerformanceCounterTelemetry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class JmxPerformanceCounter
implements PerformanceCounter {
    private final PerformanceCounterTelemetry telemetry;
    private final Map<String, Collection<JmxAttributeData>> objectToAttributes;
    private Map.Entry<String, Collection<JmxAttributeData>> entry;
    private final String id;
    private boolean relevant = true;

    public JmxPerformanceCounter(String categoryName, String counterName, final String objectName, final Collection<JmxAttributeData> attributes) {
        this(categoryName, counterName, (Map<String, Collection<JmxAttributeData>>)new HashMap<String, Collection<JmxAttributeData>>(){
            {
                this.put(objectName, attributes);
            }
        });
    }

    public JmxPerformanceCounter(String categoryName, String counterName, Map<String, Collection<JmxAttributeData>> objectToAttributes) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)categoryName) ? 1 : 0) != 0, (Object)"categoryName should be a valid non-empty value");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)counterName) ? 1 : 0) != 0, (Object)"categoryName should be a valid non-empty value");
        Preconditions.checkNotNull(objectToAttributes, (Object)"objectToAttributes should be not null");
        Preconditions.checkArgument((!objectToAttributes.isEmpty() ? 1 : 0) != 0, (Object)"objectToAttributes should be not be empty");
        this.id = categoryName + "." + counterName;
        this.telemetry = new PerformanceCounterTelemetry(categoryName, counterName, SystemInformation.INSTANCE.getProcessId(), -1.0);
        this.objectToAttributes = objectToAttributes;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void report(TelemetryClient telemetryClient) {
        if (!this.relevant) {
            return;
        }
        Map<String, Collection<Object>> data = null;
        if (this.entry == null) {
            for (Map.Entry<String, Collection<JmxAttributeData>> entry : this.objectToAttributes.entrySet()) {
                try {
                    data = JmxDataFetcher.fetch(entry.getKey(), entry.getValue());
                    this.entry = entry;
                    break;
                }
                catch (Exception e) {
                }
            }
            if (this.entry == null) {
                this.relevant = false;
                InternalLogger.INSTANCE.error("Could not find JMX data for '%s'. Performance Counter will be ignored.", this.getId());
                return;
            }
        } else {
            try {
                data = JmxDataFetcher.fetch(this.entry.getKey(), this.entry.getValue());
            }
            catch (Exception e) {
                InternalLogger.INSTANCE.error("Failed to fetch JMX data for '%s'..", this.getId());
                return;
            }
        }
        if (data == null) {
            return;
        }
        for (Map.Entry<String, Collection<Object>> displayAndValues : data.entrySet()) {
            boolean ok = true;
            double value = 0.0;
            for (Object obj : displayAndValues.getValue()) {
                try {
                    value += Double.parseDouble(String.valueOf(obj));
                }
                catch (Exception e) {
                    ok = false;
                    InternalLogger.INSTANCE.error("Error while parsing JMX value for '%s:%s': '%s'", this.getId(), displayAndValues.getKey(), e.getMessage());
                    break;
                }
            }
            if (!ok) continue;
            try {
                this.telemetry.setValue(value);
                InternalLogger.INSTANCE.trace("JMX Metric: %s:%s: %s", this.telemetry.getCategoryName(), this.telemetry.getCounterName(), value);
                telemetryClient.track(this.telemetry);
            }
            catch (Exception e) {
                InternalLogger.INSTANCE.error("Error while sending JMX data for '%s': '%s'", this.getId(), e.getMessage());
            }
        }
    }
}

