/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.internal.jmx.JmxAttributeData;
import com.microsoft.applicationinsights.internal.jmx.JmxDataFetcher;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounter;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractJmxPerformanceCounter
implements PerformanceCounter {
    private final String id;
    private final String objectName;
    private final Collection<JmxAttributeData> attributes;
    private boolean relevant = true;
    private boolean firstTime = true;

    @Override
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void report(TelemetryClient telemetryClient) {
        if (!this.relevant) {
            return;
        }
        try {
            Map<String, Collection<Object>> result = JmxDataFetcher.fetch(this.objectName, this.attributes);
            for (Map.Entry<String, Collection<Object>> displayAndValues : result.entrySet()) {
                boolean ok = true;
                double value = 0.0;
                for (Object obj : displayAndValues.getValue()) {
                    try {
                        value += Double.parseDouble(String.valueOf(obj));
                    }
                    catch (Exception e) {
                        ok = false;
                        break;
                    }
                }
                if (!ok) continue;
                try {
                    this.send(telemetryClient, displayAndValues.getKey(), value);
                }
                catch (Exception e) {
                    InternalLogger.INSTANCE.error("Error while sending JMX data: '%s'", e.getMessage());
                }
            }
        }
        catch (Exception e) {
            if (this.firstTime) {
                InternalLogger.INSTANCE.error("Error while fetching JMX data: '%s', The PC will be ignored", e.getMessage());
                this.relevant = false;
            } else {
                InternalLogger.INSTANCE.error("Error while fetching JMX data: '%s'", e.getMessage());
            }
        }
        finally {
            this.firstTime = false;
        }
    }

    protected AbstractJmxPerformanceCounter(String id, String objectName, Collection<JmxAttributeData> attributes) {
        this.id = id;
        this.objectName = objectName;
        this.attributes = attributes;
    }

    protected abstract void send(TelemetryClient var1, String var2, double var3);
}

