/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.channel.TransmissionDispatcher;
import com.microsoft.applicationinsights.internal.channel.TransmissionOutput;
import com.microsoft.applicationinsights.internal.channel.common.ApacheSender;
import com.microsoft.applicationinsights.internal.channel.common.ApacheSenderFactory;
import com.microsoft.applicationinsights.internal.channel.common.BackOffTimesPolicyFactory;
import com.microsoft.applicationinsights.internal.channel.common.SenderThreadsBackOffManager;
import com.microsoft.applicationinsights.internal.channel.common.Transmission;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionSendResult;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;

public final class TransmissionNetworkOutput
implements TransmissionOutput {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    private static final String DEFAULT_SERVER_URI = "https://dc.services.visualstudio.com/v2/track";
    private static SenderThreadsBackOffManager s_senderThreadsManager;
    private TransmissionDispatcher transmissionDispatcher;
    private final String serverUri;
    private volatile boolean stopped;
    private final ApacheSender httpClient;

    public static TransmissionNetworkOutput create() {
        return TransmissionNetworkOutput.create(DEFAULT_SERVER_URI);
    }

    public static TransmissionNetworkOutput create(String endpoint) {
        String realEndpoint = Strings.isNullOrEmpty((String)endpoint) ? DEFAULT_SERVER_URI : endpoint;
        return new TransmissionNetworkOutput(realEndpoint, null);
    }

    private TransmissionNetworkOutput(String serverUri, String backOffContainerName) {
        Preconditions.checkNotNull((Object)serverUri, (Object)"serverUri should be a valid non-null value");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serverUri) ? 1 : 0) != 0, (Object)"serverUri should be a valid non-null value");
        this.serverUri = serverUri;
        this.httpClient = new ApacheSenderFactory().create();
        this.stopped = false;
        this.initializeSenderThreadsManager(backOffContainerName);
    }

    public void setTransmissionDispatcher(TransmissionDispatcher transmissionDispatcher) {
        this.transmissionDispatcher = transmissionDispatcher;
    }

    @Override
    public synchronized void stop(long timeout, TimeUnit timeUnit) {
        if (this.stopped) {
            return;
        }
        s_senderThreadsManager.stopAllSendersBackOffActivities();
        this.httpClient.close();
        this.stopped = true;
    }

    @Override
    public boolean send(Transmission transmission) {
        block3: while (!this.stopped) {
            TransmissionSendResult result = this.doSend(transmission);
            switch (result) {
                case THROTTLED: {
                    boolean backOffDone = s_senderThreadsManager.backOffCurrentSenderThread();
                    if (backOffDone) continue block3;
                    return true;
                }
            }
            s_senderThreadsManager.onDoneSending();
            return true;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private TransmissionSendResult doSend(Transmission transmission) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TransmissionSendResult translateResponse(int code, HttpEntity respEntity) {
        TransmissionSendResult result;
        String errorMessage;
        if (code == 200) {
            return TransmissionSendResult.SENT_SUCCESSFULLY;
        }
        if (code < 200 || code >= 300 && code < 400 || code > 500) {
            errorMessage = String.format("Unexpected response code: %d", code);
            result = TransmissionSendResult.REJECTED_BY_SERVER;
        } else {
            switch (code) {
                case 400: {
                    errorMessage = "Bad request ";
                    result = TransmissionSendResult.BAD_REQUEST;
                    break;
                }
                case 429: {
                    result = TransmissionSendResult.THROTTLED;
                    errorMessage = "Throttling (All messages of the transmission were rejected) ";
                    break;
                }
                case 206: {
                    result = TransmissionSendResult.PARTIALLY_THROTTLED;
                    errorMessage = "Throttling (Partial messages of the transmission were rejected) ";
                    break;
                }
                case 500: {
                    errorMessage = "Internal server error ";
                    result = TransmissionSendResult.INTERNAL_SERVER_ERROR;
                    break;
                }
                default: {
                    result = TransmissionSendResult.REJECTED_BY_SERVER;
                    errorMessage = String.format("Error, response code: %d", code);
                }
            }
        }
        this.logError(errorMessage, respEntity);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logError(String baseErrorMessage, HttpEntity respEntity) {
        if (respEntity == null || !InternalLogger.INSTANCE.isErrorEnabled()) {
            InternalLogger.INSTANCE.error(baseErrorMessage, new Object[0]);
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = respEntity.getContent();
            InputStreamReader streamReader = new InputStreamReader(inputStream, "UTF-8");
            BufferedReader reader = new BufferedReader(streamReader);
            String responseLine = reader.readLine();
            respEntity.getContent().close();
            InternalLogger.INSTANCE.error("Failed to send, %s : %s", baseErrorMessage, responseLine);
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Failed to send, %s, failed to log the error", baseErrorMessage);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private HttpPost createTransmissionPostRequest(Transmission transmission) {
        HttpPost request = new HttpPost(this.serverUri);
        request.addHeader(CONTENT_TYPE_HEADER, transmission.getWebContentType());
        request.addHeader(CONTENT_ENCODING_HEADER, transmission.getWebContentEncodingType());
        ByteArrayEntity bae = new ByteArrayEntity(transmission.getContent());
        request.setEntity((HttpEntity)bae);
        return request;
    }

    private synchronized void initializeSenderThreadsManager(String backOffContainerName) {
        if (s_senderThreadsManager != null) {
            return;
        }
        s_senderThreadsManager = new SenderThreadsBackOffManager(new BackOffTimesPolicyFactory().create(backOffContainerName));
    }
}

