/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.microsoft.applicationinsights.internal.channel.TransmissionOutput;
import com.microsoft.applicationinsights.internal.channel.common.Transmission;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.LimitsEnforcer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public final class TransmissionFileSystemOutput
implements TransmissionOutput {
    private static final String TRANSMISSION_FILE_PREFIX = "Transmission";
    private static final String TRANSMISSION_DEFAULT_FOLDER = "transmissions";
    private static final String TEMP_FILE_EXTENSION = ".tmp";
    private static final String TRANSMISSION_FILE_EXTENSION = ".trn";
    private static final String TRANSMISSION_FILE_EXTENSION_FOR_SEARCH = "trn";
    private static final int NUMBER_OF_FILES_TO_CACHE = 128;
    private static final int MAX_RETRY_FOR_DELETE = 2;
    private static final int DELETE_TIMEOUT_ON_FAILURE_IN_MILLS = 100;
    private static final int DEFAULT_CAPACITY_MEGABYTES = 10;
    private static final int MAX_CAPACITY_MEGABYTES = 100;
    private static final int MIN_CAPACITY_MEGABYTES = 1;
    private static final String MAX_TRANSMISSION_STORAGE_CAPACITY_NAME = "Channel.MaxTransmissionStorageCapacityInMB";
    private File folder;
    private long capacityInKB = 10240L;
    LimitsEnforcer capacityEnforcer;
    private final AtomicLong size;
    private final ArrayList<File> cacheOfOldestFiles = new ArrayList();
    private final HashSet<String> filesThatAreBeingLoaded = new HashSet();

    public TransmissionFileSystemOutput(String folderPath, String maxTransmissionStorageCapacity) {
        if (folderPath == null) {
            folderPath = new File(System.getProperty("java.io.tmpdir"), TRANSMISSION_DEFAULT_FOLDER).getPath();
        }
        this.capacityEnforcer = LimitsEnforcer.createWithClosestLimitOnError(1, 100, 10, MAX_TRANSMISSION_STORAGE_CAPACITY_NAME, maxTransmissionStorageCapacity);
        this.capacityInKB = this.capacityEnforcer.getCurrentValue() * 1024;
        this.folder = new File(folderPath);
        if (!this.folder.exists()) {
            this.folder.mkdir();
        }
        if (!(this.folder.exists() && this.folder.canRead() && this.folder.canWrite())) {
            throw new IllegalArgumentException("Folder must exist with read and write permissions");
        }
        long currentSize = this.getTotalSizeOfTransmissionFiles();
        this.size = new AtomicLong(currentSize);
    }

    public TransmissionFileSystemOutput() {
        this(null, null);
    }

    public TransmissionFileSystemOutput(String folderPath) {
        this(folderPath, null);
    }

    @Override
    public boolean send(Transmission transmission) {
        if (this.size.get() >= this.capacityInKB) {
            return false;
        }
        Optional<File> tempTransmissionFile = this.createTemporaryFile();
        if (!tempTransmissionFile.isPresent()) {
            return false;
        }
        if (!this.saveTransmission((File)tempTransmissionFile.get(), transmission)) {
            return false;
        }
        return this.renameToPermanentName((File)tempTransmissionFile.get());
    }

    @Override
    public void stop(long timeout, TimeUnit timeUnit) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Transmission fetchOldestFile() {
        try {
            Optional<File> oldestFile = this.fetchOldestFromCache();
            if (!oldestFile.isPresent()) {
                return null;
            }
            String fileName = ((File)oldestFile.get()).getName();
            try {
                Optional<File> oldestFileAsTemp = this.renameToTemporaryName((File)oldestFile.get());
                if (!oldestFileAsTemp.isPresent()) {
                    Transmission transmission = null;
                    return transmission;
                }
                File tempFile = (File)oldestFileAsTemp.get();
                Optional<Transmission> transmission = this.loadTransmission(tempFile);
                for (int deleteCounter = 0; deleteCounter < 2 && !tempFile.delete(); ++deleteCounter) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                Transmission transmission2 = (Transmission)transmission.get();
                return transmission2;
            }
            finally {
                TransmissionFileSystemOutput transmissionFileSystemOutput = this;
                synchronized (transmissionFileSystemOutput) {
                    this.filesThatAreBeingLoaded.remove(fileName);
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setCapacity(int suggestedCapacity) {
        this.capacityInKB = this.capacityEnforcer.normalizeValue(suggestedCapacity) * 1024;
    }

    private List<File> sortOldestLastAndTrim(Collection<File> transmissions, int limit) {
        List asList = !(transmissions instanceof List) ? Lists.newArrayList(transmissions) : (List)transmissions;
        Collections.sort(asList, new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                long file2LastModified;
                long file1LastModified = file1.lastModified();
                if (file1LastModified < (file2LastModified = file2.lastModified())) {
                    return 1;
                }
                if (file1LastModified > file2LastModified) {
                    return -1;
                }
                return 0;
            }
        });
        if (asList.size() > limit) {
            asList = asList.subList(0, limit);
        }
        return asList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Transmission> loadTransmission(File file) {
        Transmission transmission = null;
        FileInputStream fileInput = null;
        ObjectInput input = null;
        try {
            if (file == null) {
                Optional optional = Optional.absent();
                return optional;
            }
            fileInput = new FileInputStream(file);
            BufferedInputStream buffer = new BufferedInputStream(fileInput);
            input = new ObjectInputStream(buffer);
            transmission = (Transmission)input.readObject();
        }
        catch (FileNotFoundException e) {
            InternalLogger.INSTANCE.error("Failed to load transmission, file not found, exception: %s", e.getMessage());
        }
        catch (ClassNotFoundException e) {
            InternalLogger.INSTANCE.error("Failed to load transmission, non transmission, exception: %s", e.getMessage());
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Failed to load transmission, io exception: %s", e.getMessage());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        return Optional.fromNullable(transmission);
    }

    private boolean renameToPermanentName(File tempTransmissionFile) {
        File transmissionFile = new File(this.folder, FilenameUtils.getBaseName((String)tempTransmissionFile.getName()) + TRANSMISSION_FILE_EXTENSION);
        try {
            long fileLength = tempTransmissionFile.length();
            FileUtils.moveFile((File)tempTransmissionFile, (File)transmissionFile);
            this.size.addAndGet(fileLength);
            return true;
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Rename To Permanent Name failed, exception: %s", e.getMessage());
            return false;
        }
    }

    private Optional<File> renameToTemporaryName(File tempTransmissionFile) {
        File transmissionFile = null;
        try {
            File renamedFile = new File(this.folder, FilenameUtils.getBaseName((String)tempTransmissionFile.getName()) + TEMP_FILE_EXTENSION);
            FileUtils.moveFile((File)tempTransmissionFile, (File)renamedFile);
            this.size.addAndGet(-renamedFile.length());
            transmissionFile = renamedFile;
        }
        catch (Exception ignore) {
            InternalLogger.INSTANCE.error("Rename To Temporary Name failed, exception: %s", ignore.getMessage());
        }
        return Optional.fromNullable(transmissionFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveTransmission(File transmissionFile, Transmission transmission) {
        try {
            FileOutputStream fileOutput = new FileOutputStream(transmissionFile);
            BufferedOutputStream buffer = new BufferedOutputStream(fileOutput);
            ObjectOutputStream output = new ObjectOutputStream(buffer);
            try {
                output.writeObject(transmission);
            }
            catch (IOException e) {
                InternalLogger.INSTANCE.error("Failed to save transmission, exception: %s", e.getMessage());
            }
            finally {
                try {
                    output.close();
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Failed to save transmission, exception: %s", e.getMessage());
            return false;
        }
    }

    private Optional<File> createTemporaryFile() {
        File file = null;
        try {
            file = File.createTempFile(TRANSMISSION_FILE_PREFIX, null, this.folder);
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Failed to create temporary file, exception: %s", e.getMessage());
        }
        return Optional.fromNullable((Object)file);
    }

    private long getTotalSizeOfTransmissionFiles() {
        Collection transmissions = FileUtils.listFiles((File)this.folder, (String[])new String[]{TRANSMISSION_FILE_EXTENSION_FOR_SEARCH}, (boolean)false);
        long totalSize = 0L;
        for (File file : transmissions) {
            totalSize += file.length();
        }
        return totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<File> fetchOldestFromCache() {
        TransmissionFileSystemOutput transmissionFileSystemOutput = this;
        synchronized (transmissionFileSystemOutput) {
            File fileToLoad;
            String fileName;
            if (this.cacheOfOldestFiles.isEmpty()) {
                Collection transmissions = FileUtils.listFiles((File)this.folder, (String[])new String[]{TRANSMISSION_FILE_EXTENSION_FOR_SEARCH}, (boolean)false);
                if (transmissions.isEmpty()) {
                    return Optional.absent();
                }
                List<File> filesToLoad = this.sortOldestLastAndTrim(transmissions, 128);
                if (filesToLoad == null || filesToLoad.isEmpty()) {
                    return Optional.absent();
                }
                this.cacheOfOldestFiles.addAll(filesToLoad);
            }
            if (this.filesThatAreBeingLoaded.contains(fileName = (fileToLoad = this.cacheOfOldestFiles.remove(this.cacheOfOldestFiles.size() - 1)).getName())) {
                return Optional.absent();
            }
            this.filesThatAreBeingLoaded.add(fileName);
            return Optional.fromNullable((Object)fileToLoad);
        }
    }
}

