/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.extensibility.initializer.docker;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.agent.internal.common.StringUtils;
import com.microsoft.applicationinsights.extensibility.TelemetryInitializer;
import com.microsoft.applicationinsights.extensibility.initializer.docker.internal.DockerContext;
import com.microsoft.applicationinsights.extensibility.initializer.docker.internal.DockerContextPoller;
import com.microsoft.applicationinsights.extensibility.initializer.docker.internal.FileFactory;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import com.microsoft.applicationinsights.telemetry.TelemetryContext;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;

public class DockerContextInitializer
implements TelemetryInitializer {
    private FileFactory fileFactory;
    private DockerContextPoller dockerContextPoller;
    private boolean sdkInfoFileWritten = false;

    protected DockerContextInitializer(FileFactory fileFactory, DockerContextPoller dockerContextPoller) {
        this.fileFactory = fileFactory;
        this.dockerContextPoller = dockerContextPoller;
        this.dockerContextPoller.start();
    }

    public DockerContextInitializer() {
        this(new FileFactory(), new DockerContextPoller("/usr/appinsights/docker"));
    }

    @Override
    public void initialize(Telemetry telemetry) {
        DockerContext dockerContext;
        if (!this.sdkInfoFileWritten) {
            this.writeSDKInfoFile();
            this.sdkInfoFileWritten = true;
        }
        if (this.dockerContextPoller.isCompleted() && (dockerContext = this.dockerContextPoller.getDockerContext()) != null) {
            TelemetryContext context = telemetry.getContext();
            String containerName = dockerContext.getProperties().get("docker-container-name");
            context.getDevice().setId(containerName);
            if (!StringUtils.isNullOrEmpty((String)((String)context.getProperties().get("docker-host")))) {
                return;
            }
            ConcurrentMap<String, String> properties = context.getProperties();
            properties.putAll(dockerContext.getProperties());
        }
    }

    private void writeSDKInfoFile() {
        String sdkInfoFilePath = String.format("%s/%s", "/usr/appinsights/docker", "sdk.info");
        String instrumentationKey = TelemetryConfiguration.getActive().getInstrumentationKey();
        String sdkInfo = String.format("InstrumentationKey=", instrumentationKey);
        try {
            this.fileFactory.create(sdkInfoFilePath, sdkInfo);
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Failed to write SDK info file for Docker awareness. Error: " + e.getMessage(), new Object[0]);
        }
    }
}

