/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.schemav2.DependencyKind;
import com.microsoft.applicationinsights.internal.schemav2.DependencySourceType;
import com.microsoft.applicationinsights.internal.schemav2.RemoteDependencyData;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.BaseTelemetry;

public final class RemoteDependencyTelemetry
extends BaseTelemetry<RemoteDependencyData> {
    private final RemoteDependencyData data = new RemoteDependencyData();

    public RemoteDependencyTelemetry() {
        this.initialize(this.data.getProperties());
    }

    public RemoteDependencyTelemetry(String name) {
        this();
        this.setName(name);
    }

    public String getName() {
        return this.data.getName();
    }

    public void setName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("The event name cannot be null or empty");
        }
        this.data.setName(name);
    }

    public double getValue() {
        return this.data.getValue();
    }

    public void setValue(double value) {
        this.data.setValue(value);
    }

    public Integer getCount() {
        return this.data.getCount();
    }

    public void setCount(Integer value) {
        this.data.setCount(value);
    }

    public Double getMin() {
        return this.data.getMin();
    }

    public void setMin(Double value) {
        this.data.setMin(value);
    }

    public Double getMax() {
        return this.data.getMax();
    }

    public void setMax(Double value) {
        this.data.setMax(value);
    }

    public Double getStdDev() {
        return this.data.getStdDev();
    }

    public void setStdDev(Double value) {
        this.data.setStdDev(value);
    }

    public DependencyKind getDependencyKind() {
        return this.data.getDependencyKind();
    }

    public void setDependencyKind(DependencyKind value) {
        this.data.setDependencyKind(value);
    }

    public boolean getSuccess() {
        return this.data.getSuccess();
    }

    public void setSuccess(boolean value) {
        this.data.setSuccess(value);
    }

    public Boolean getAsync() {
        return this.data.getAsync();
    }

    public void setAsync(Boolean value) {
        this.data.setAsync(value);
    }

    public DependencySourceType getDependencySource() {
        return this.data.getDependencySource();
    }

    public void setDependencySource(DependencySourceType value) {
        this.data.setDependencySource(value);
    }

    @Override
    protected void additionalSanitize() {
        this.data.setName(Sanitizer.sanitizeName(this.data.getName()));
    }

    @Override
    protected RemoteDependencyData getData() {
        return this.data;
    }
}

