/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.telemetry.JsonSerializable;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;

public final class JsonTelemetryDataSerializer {
    private static final String JSON_SEPARATOR = ",";
    private static final String JSON_START_OBJECT = "{";
    private static final String JSON_CLOSE_OBJECT = "}";
    private static final String JSON_START_ARRAY = "[";
    private static final String JSON_CLOSE_ARRAY = "]";
    private static final String JSON_COMMA = "\"";
    private static final String JSON_NAME_VALUE_SEPARATOR = ":";
    private static final String JSON_EMPTY_OBJECT = "{}";
    private Writer out;
    private String separator = "";

    public JsonTelemetryDataSerializer(Writer out) throws IOException {
        this.reset(out);
    }

    public void reset(Writer out) throws IOException {
        this.separator = "";
        this.out = out;
        this.out.write(JSON_START_OBJECT);
    }

    public void close() throws IOException {
        this.out.write(JSON_CLOSE_OBJECT);
        this.out.close();
    }

    public void write(String name, int value) throws IOException {
        this.writeName(name);
        this.out.write(JSON_COMMA);
        this.out.write(String.valueOf(value));
        this.out.write(JSON_COMMA);
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, Integer value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeName(name);
        this.out.write(JSON_COMMA);
        this.out.write(String.valueOf(value));
        this.out.write(JSON_COMMA);
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, double value) throws IOException {
        this.writeName(name);
        this.out.write(JSON_COMMA);
        this.out.write(String.valueOf(value));
        this.out.write(JSON_COMMA);
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, Double value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeName(name);
        this.out.write(JSON_COMMA);
        this.out.write(String.valueOf(value));
        this.out.write(JSON_COMMA);
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, short value) throws IOException {
        this.writeName(name);
        this.out.write(JSON_COMMA);
        this.out.write(String.valueOf(value));
        this.out.write(JSON_COMMA);
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, Short value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeName(name);
        this.out.write(JSON_COMMA);
        this.out.write(String.valueOf(value));
        this.out.write(JSON_COMMA);
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, long value) throws IOException {
        this.writeName(name);
        this.out.write(JSON_COMMA);
        this.out.write(String.valueOf(value));
        this.out.write(JSON_COMMA);
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, Long value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeName(name);
        this.out.write(JSON_COMMA);
        this.out.write(String.valueOf(value));
        this.out.write(JSON_COMMA);
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, boolean value) throws IOException {
        this.writeName(name);
        this.out.write(JSON_COMMA);
        this.out.write(String.valueOf(value));
        this.out.write(JSON_COMMA);
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, Boolean value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeName(name);
        this.out.write(JSON_COMMA);
        this.out.write(String.valueOf(value));
        this.out.write(JSON_COMMA);
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, Date value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeName(name);
        this.write(LocalStringsUtils.getDateFormatter().format(value));
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, String value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeName(name);
        this.out.write(JSON_COMMA);
        this.writeEscapedString(value);
        this.out.write(JSON_COMMA);
        this.separator = JSON_SEPARATOR;
    }

    public <T extends JsonSerializable> void write(String name, T value) throws IOException {
        if (value == null) {
            return;
        }
        String jsonStringToAppend = this.createJsonFor(value);
        if (Strings.isNullOrEmpty((String)jsonStringToAppend)) {
            return;
        }
        this.writeName(name);
        this.out.write(jsonStringToAppend);
        this.separator = JSON_SEPARATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void write(String name, Map<String, T> map) throws IOException {
        if (map == null) {
            return;
        }
        this.writeName(name);
        try {
            if (map.size() < 1) {
                this.out.write("null");
            } else {
                this.out.write(JSON_START_OBJECT);
                this.separator = "";
                for (Map.Entry<String, T> entry : map.entrySet()) {
                    this.writeName(entry.getKey());
                    this.write(entry.getValue());
                    this.separator = JSON_SEPARATOR;
                }
                this.out.write(JSON_CLOSE_OBJECT);
            }
        }
        finally {
            this.separator = JSON_SEPARATOR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void write(String name, List<T> list) throws IOException {
        if (list == null) {
            return;
        }
        this.writeName(name);
        try {
            if (list.size() < 1) {
                this.out.write("null");
            } else {
                this.out.write(JSON_START_ARRAY);
                this.separator = "";
                for (T item : list) {
                    this.out.write(this.separator);
                    this.write(item);
                    this.separator = JSON_SEPARATOR;
                }
                this.out.write(JSON_CLOSE_ARRAY);
            }
        }
        finally {
            this.separator = JSON_SEPARATOR;
        }
    }

    private <T> void write(T item) throws IOException {
        if (item instanceof JsonSerializable) {
            StringWriter stringWriter = new StringWriter();
            String jsonStringToAppend = this.createJsonFor((JsonSerializable)item);
            if (Strings.isNullOrEmpty((String)jsonStringToAppend)) {
                return;
            }
            this.out.write(jsonStringToAppend);
        } else {
            this.out.write(JSON_COMMA);
            this.out.write(String.valueOf(item));
            this.out.write(JSON_COMMA);
        }
    }

    private <T extends JsonSerializable> String createJsonFor(T value) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JsonTelemetryDataSerializer temp = new JsonTelemetryDataSerializer(new BufferedWriter(stringWriter));
        value.serialize(temp);
        temp.close();
        String jsonStringToAppend = stringWriter.toString();
        if (Strings.isNullOrEmpty((String)jsonStringToAppend) || JSON_EMPTY_OBJECT.equals(jsonStringToAppend)) {
            return "";
        }
        return jsonStringToAppend;
    }

    private void writeName(String name) throws IOException {
        this.out.write(this.separator);
        this.out.write(JSON_COMMA);
        this.out.write(name);
        this.out.write(JSON_COMMA);
        this.out.write(JSON_NAME_VALUE_SEPARATOR);
    }

    protected void writeEscapedString(String value) throws IOException {
        block9: for (char c : value.toCharArray()) {
            switch (c) {
                case '\\': {
                    this.out.write("\\\\");
                    continue block9;
                }
                case '\"': {
                    this.out.write("\\\"");
                    continue block9;
                }
                case '\n': {
                    this.out.write("\\n");
                    continue block9;
                }
                case '\b': {
                    this.out.write("\\b");
                    continue block9;
                }
                case '\f': {
                    this.out.write("\\f");
                    continue block9;
                }
                case '\r': {
                    this.out.write("\\r");
                    continue block9;
                }
                case '\t': {
                    this.out.write("\\t");
                    continue block9;
                }
                default: {
                    this.out.write(c);
                }
            }
        }
    }
}

