/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.schemav2.RequestData;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.BaseTelemetry;
import com.microsoft.applicationinsights.telemetry.Duration;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.ConcurrentMap;

public final class HttpRequestTelemetry
extends BaseTelemetry<RequestData> {
    private final RequestData data = new RequestData();

    public HttpRequestTelemetry() {
        this.initialize(this.data.getProperties());
        this.setId(LocalStringsUtils.generateRandomId());
        this.setTimestamp(new Date());
        this.setResponseCode(Integer.toString(200));
        this.setSuccess(true);
    }

    public HttpRequestTelemetry(String name, Date timestamp, long duration, String responseCode, boolean success) {
        this(name, timestamp, new Duration(duration), responseCode, success);
    }

    public HttpRequestTelemetry(String name, Date timestamp, Duration duration, String responseCode, boolean success) {
        this.initialize(this.data.getProperties());
        this.setId(LocalStringsUtils.generateRandomId());
        this.setTimestamp(timestamp);
        this.setName(name);
        this.setDuration(duration);
        this.setResponseCode(responseCode);
        this.setSuccess(success);
    }

    ConcurrentMap<String, Double> getMetrics() {
        return this.data.getMeasurements();
    }

    @Override
    public void setTimestamp(Date timestamp) {
        if (timestamp == null) {
            timestamp = new Date();
        }
        super.setTimestamp(timestamp);
        this.data.setStartTime(timestamp);
    }

    public String getName() {
        return this.data.getName();
    }

    public void setName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("The event name cannot be null or empty");
        }
        this.data.setName(name);
    }

    public String getId() {
        return this.data.getId();
    }

    public void setId(String id) {
        this.data.setId(id);
    }

    public String getResponseCode() {
        return this.data.getResponseCode();
    }

    public void setResponseCode(String responseCode) {
        this.data.setResponseCode(responseCode);
    }

    public boolean isSuccess() {
        return this.data.isSuccess();
    }

    public void setSuccess(boolean success) {
        this.data.setSuccess(success);
    }

    public Duration getDuration() {
        return this.data.getDuration();
    }

    public void setDuration(Duration duration) {
        this.data.setDuration(duration);
    }

    public URL getUrl() throws MalformedURLException {
        if (LocalStringsUtils.isNullOrEmpty(this.data.getUrl())) {
            return null;
        }
        return new URL(this.data.getUrl());
    }

    public void setUrl(URL url) {
        this.data.setUrl(url.toString());
    }

    public void setUrl(String url) throws MalformedURLException {
        URL u = new URL(url);
        this.data.setUrl(u.toString());
    }

    public String getHttpMethod() {
        return this.data.getHttpMethod();
    }

    public void setHttpMethod(String httpMethod) {
        this.data.setHttpMethod(httpMethod);
    }

    @Override
    protected void additionalSanitize() {
        this.data.setName(Sanitizer.sanitizeName(this.data.getName()));
        this.data.setId(Sanitizer.sanitizeName(this.data.getId()));
        Sanitizer.sanitizeMeasurements(this.getMetrics());
        Sanitizer.sanitizeUri(this.data.getUrl());
    }

    @Override
    protected RequestData getData() {
        return this.data;
    }
}

