/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.schemav2.ExceptionData;
import com.microsoft.applicationinsights.internal.schemav2.ExceptionDetails;
import com.microsoft.applicationinsights.internal.schemav2.StackFrame;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.BaseTelemetry;
import com.microsoft.applicationinsights.telemetry.ExceptionHandledAt;
import com.microsoft.applicationinsights.telemetry.SeverityLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

public final class ExceptionTelemetry
extends BaseTelemetry<ExceptionData> {
    private final ExceptionData data = new ExceptionData();
    private Exception exception;

    private ExceptionTelemetry() {
        this.initialize(this.data.getProperties());
        this.setExceptionHandledAt(ExceptionHandledAt.Unhandled);
    }

    public ExceptionTelemetry(Exception exception) {
        this();
        this.setException(exception);
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
        this.updateException(exception);
    }

    public ExceptionHandledAt getExceptionHandledAt() {
        return Enum.valueOf(ExceptionHandledAt.class, this.data.getHandledAt());
    }

    public void setExceptionHandledAt(ExceptionHandledAt value) {
        this.data.setHandledAt(value.toString());
    }

    public ConcurrentMap<String, Double> getMetrics() {
        return this.data.getMeasurements();
    }

    public void setSeverityLevel(SeverityLevel severityLevel) {
        this.data.setSeverityLevel(severityLevel);
    }

    public SeverityLevel getSeverityLevel() {
        return this.data.getSeverityLevel();
    }

    @Override
    protected void additionalSanitize() {
        Sanitizer.sanitizeMeasurements(this.getMetrics());
    }

    @Override
    protected ExceptionData getData() {
        return this.data;
    }

    protected List<ExceptionDetails> getExceptions() {
        return this.data.getExceptions();
    }

    private void updateException(Exception exception) {
        ArrayList<ExceptionDetails> exceptions = new ArrayList<ExceptionDetails>();
        ExceptionTelemetry.convertExceptionTree(exception, null, exceptions);
        this.data.setExceptions(exceptions);
    }

    private static void convertExceptionTree(Throwable exception, ExceptionDetails parentExceptionDetails, List<ExceptionDetails> exceptions) {
        if (exception == null) {
            exception = new Exception("");
        }
        ExceptionDetails exceptionDetails = ExceptionTelemetry.createWithStackInfo(exception, parentExceptionDetails);
        exceptions.add(exceptionDetails);
        if (exception.getCause() != null) {
            ExceptionTelemetry.convertExceptionTree(exception.getCause(), exceptionDetails, exceptions);
        }
    }

    private static ExceptionDetails createWithStackInfo(Throwable exception, ExceptionDetails parentExceptionDetails) {
        StackTraceElement[] trace;
        if (exception == null) {
            throw new IllegalArgumentException("exception cannot be null");
        }
        ExceptionDetails exceptionDetails = new ExceptionDetails();
        exceptionDetails.setId(LocalStringsUtils.generateRandomIntegerId());
        exceptionDetails.setTypeName(exception.getClass().getName());
        String exceptionMessage = exception.getMessage();
        if (Strings.isNullOrEmpty((String)exceptionMessage)) {
            exceptionMessage = exception.getClass().getName();
        }
        exceptionDetails.setMessage(exceptionMessage);
        if (parentExceptionDetails != null) {
            exceptionDetails.setOuterId(parentExceptionDetails.getId());
        }
        if ((trace = exception.getStackTrace()) != null && trace.length > 0) {
            ArrayList<StackFrame> stack = exceptionDetails.getParsedStack();
            for (int idx = 0; idx < trace.length; ++idx) {
                StackTraceElement elem = trace[idx];
                if (elem.isNativeMethod()) continue;
                String className = elem.getClassName();
                StackFrame frame = new StackFrame();
                frame.setLevel(idx);
                frame.setFileName(elem.getFileName());
                frame.setLine(elem.getLineNumber());
                if (!Strings.isNullOrEmpty((String)className)) {
                    frame.setMethod(elem.getClassName() + "." + elem.getMethodName());
                } else {
                    frame.setMethod(elem.getMethodName());
                }
                stack.add(frame);
            }
            exceptionDetails.setHasFullStack(true);
        }
        return exceptionDetails;
    }
}

