/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.util;

import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.ChannelFetcher;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public enum SDKShutdownActivity {
    INSTANCE;

    private static volatile SDKShutdownThread shutdownThread;

    public void register(ChannelFetcher fetcher) {
        this.getShutdownThread().register(fetcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SDKShutdownThread getShutdownThread() {
        if (shutdownThread == null) {
            SDKShutdownActivity sDKShutdownActivity = this;
            synchronized (sDKShutdownActivity) {
                if (shutdownThread == null) {
                    try {
                        shutdownThread = new SDKShutdownThread();
                        Runtime.getRuntime().addShutdownHook(shutdownThread);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return shutdownThread;
    }

    private static class SDKShutdownThread
    extends Thread {
        private boolean stopped = false;
        private final ArrayList<ChannelFetcher> fetchers = new ArrayList();

        public synchronized void register(ChannelFetcher fetcher) {
            this.fetchers.add(fetcher);
        }

        @Override
        public synchronized void run() {
            if (this.stopped) {
                return;
            }
            try {
                this.stopChannels();
            }
            finally {
                this.stopInternalLogger();
            }
            this.stopped = true;
        }

        private void stopInternalLogger() {
            try {
                InternalLogger.INSTANCE.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void stopChannels() {
            for (ChannelFetcher fetcher : this.fetchers) {
                try {
                    TelemetryChannel channelToStop = fetcher.fetch();
                    if (channelToStop == null) continue;
                    channelToStop.stop(1L, TimeUnit.SECONDS);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

