/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.UUID;

public class LocalStringsUtils {
    private static Calendar s_calendar;
    private static DateFormat s_dateFormatter;
    private static DateFormat s_durationFormatter;

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static String populateRequiredStringWithNullValue(String value, String parameterName, String telemetryType) {
        if (LocalStringsUtils.isNullOrEmpty(value)) {
            return parameterName + " is a required field for " + telemetryType;
        }
        return value;
    }

    public static boolean tryParseByte(String str) {
        try {
            Byte.parseByte(str);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static String generateRandomId() {
        return UUID.randomUUID().toString();
    }

    public static int generateRandomIntegerId() {
        long lsb = UUID.randomUUID().getLeastSignificantBits();
        return (int)(lsb & Integer.MAX_VALUE);
    }

    public static DateFormat getDateFormatter() {
        if (s_dateFormatter == null) {
            s_dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
        }
        return s_dateFormatter;
    }
}

