/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.config;

import com.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.config.ConfigFileParser;
import com.microsoft.applicationinsights.internal.config.TelemetryConfigurationFactory;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class XmlConfigParser
implements ConfigFileParser {
    private Document doc;

    XmlConfigParser() {
    }

    @Override
    public boolean parse(String fileName) {
        try {
            InputStream inputStream = this.getConfigurationAsInputStream(fileName);
            if (inputStream == null) {
                InternalLogger.INSTANCE.error("Could not find configuration file: %s.", fileName);
                return false;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.doc = db.parse(inputStream);
            this.doc.getDocumentElement().normalize();
            return true;
        }
        catch (ParserConfigurationException e) {
            InternalLogger.INSTANCE.error("Failed to parse file %s, exception: %s", fileName, e.getMessage());
        }
        catch (SAXException e) {
            InternalLogger.INSTANCE.error("Failed to parse file %s, exception: %s", fileName, e.getMessage());
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Failed to parse file %s, exception: %s", fileName, e.getMessage());
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to parse file %s, exception: %s", fileName, e.getMessage());
        }
        return false;
    }

    @Override
    public String getTrimmedValue(String itemName) {
        Element element = this.getFirstElementInDoc(itemName);
        if (element != null) {
            return element.getTextContent().trim();
        }
        return null;
    }

    @Override
    public Collection<String> getList(String sectionName, String listItemName, String attributeName) {
        ArrayList<String> result = new ArrayList<String>();
        Element sectionElement = this.getFirstElementInDoc(sectionName);
        if (sectionElement == null) {
            return result;
        }
        NodeList items = sectionElement.getElementsByTagName(listItemName);
        for (int i = 0; i < items.getLength(); ++i) {
            String attributeValue;
            Node elementItem = items.item(i);
            if (elementItem.getNodeType() != 1 || (attributeValue = ((Element)elementItem).getAttribute(attributeName)) == null) continue;
            result.add(attributeValue);
        }
        return result;
    }

    @Override
    public ConfigFileParser.StructuredDataResult getStructuredData(String sectionName, String sectionTag) {
        HashMap<String, String> items = new HashMap<String, String>();
        String sectionTagValue = null;
        Element sectionElement = this.getFirstElementInDoc(sectionName);
        if (sectionElement == null) {
            return new ConfigFileParser.StructuredDataResult(sectionTagValue, items, false);
        }
        if (!Strings.isNullOrEmpty((String)sectionTag)) {
            sectionTagValue = sectionElement.getAttribute(sectionTag);
        }
        NodeList nodes = sectionElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node elementItem = nodes.item(i);
            if (elementItem.getNodeType() != 1) continue;
            String elementName = elementItem.getNodeName().trim();
            items.put(elementName, elementItem.getTextContent().trim());
        }
        return new ConfigFileParser.StructuredDataResult(sectionTagValue, items);
    }

    private InputStream getConfigurationAsInputStream(String fileName) {
        ClassLoader classLoader = TelemetryConfigurationFactory.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(fileName);
        if (inputStream == null) {
            try {
                String jarFullPath = TelemetryConfigurationFactory.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                File jarFile = new File(jarFullPath);
                if (jarFile.exists()) {
                    String jarDirectory = jarFile.getParent();
                    String configurationPath = jarDirectory + "/" + fileName;
                    inputStream = new FileInputStream(configurationPath);
                }
            }
            catch (URISyntaxException e) {
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        return inputStream;
    }

    private Element getFirstElementInDoc(String sectionName) {
        NodeList nodeList = this.doc.getElementsByTagName(sectionName);
        Element sectionElement = XmlConfigParser.getFirstElement(nodeList);
        return sectionElement;
    }

    private static Element getFirstElement(NodeList nodeList) {
        for (int counter = 0; counter < nodeList.getLength(); ++counter) {
            Node elementNode = nodeList.item(counter);
            if (elementNode.getNodeType() != 1) continue;
            return (Element)elementNode;
        }
        return null;
    }
}

