/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.config;

import com.google.common.base.Strings;
import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.channel.concrete.inprocess.InProcessTelemetryChannel;
import com.microsoft.applicationinsights.extensibility.ContextInitializer;
import com.microsoft.applicationinsights.extensibility.TelemetryInitializer;
import com.microsoft.applicationinsights.extensibility.TelemetryModule;
import com.microsoft.applicationinsights.extensibility.initializer.DeviceInfoContextInitializer;
import com.microsoft.applicationinsights.extensibility.initializer.SdkVersionContextInitializer;
import com.microsoft.applicationinsights.internal.config.ConfigFileParser;
import com.microsoft.applicationinsights.internal.config.XmlConfigParser;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public enum TelemetryConfigurationFactory {
    INSTANCE;

    private static final String CONFIG_FILE_NAME = "ApplicationInsights.xml";
    private static final String CONTEXT_INITIALIZERS_SECTION = "ContextInitializers";
    private static final String TELEMETRY_INITIALIZERS_SECTION = "TelemetryInitializers";
    private static final String TELEMETRY_MODULES_SECTION = "TelemetryModules";
    private static final String INITIALIZERS_ADD = "Add";
    private static final String CLASS_TYPE_AS_ATTRIBUTE = "type";
    private static final String CHANNEL_SECTION = "Channel";
    private static final String DISABLE_TELEMETRY_SECTION = "DisableTelemetry";
    private static final String INSTRUMENTATION_KEY_SECTION = "InstrumentationKey";
    private static final String LOGGER_SECTION = "SDKLogger";
    private ConfigFileParser parser;
    private String fileToParse = "ApplicationInsights.xml";

    public final void initialize(TelemetryConfiguration configuration) {
        try {
            if (this.parser == null) {
                this.parser = new XmlConfigParser();
            }
            if (!this.parser.parse(this.fileToParse)) {
                configuration.setChannel(new InProcessTelemetryChannel());
                return;
            }
            this.setInternalLogger(this.parser, configuration);
            this.setInstrumentationKey(this.parser, configuration);
            if (!this.setChannel(this.parser, configuration)) {
                return;
            }
            this.setTrackingDisabledMode(this.parser, configuration);
            this.setContextInitializers(this.parser, configuration);
            this.setTelemetryInitializers(this.parser, configuration);
            this.setTelemetryModules(this.parser, configuration);
            this.initializeComponents(configuration);
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to initialize configuration, exception: %s", e.getMessage());
        }
    }

    public void setParserData(ConfigFileParser parser, String fileToParse) {
        this.fileToParse = fileToParse;
        this.parser = parser;
    }

    private void setTrackingDisabledMode(ConfigFileParser parser, TelemetryConfiguration configuration) {
        configuration.setTrackingIsDisabled(this.fetchBooleanValue(parser, DISABLE_TELEMETRY_SECTION, false));
    }

    private void setInternalLogger(ConfigFileParser parser, TelemetryConfiguration configuration) {
        ConfigFileParser.StructuredDataResult loggerData = parser.getStructuredData(LOGGER_SECTION, CLASS_TYPE_AS_ATTRIBUTE);
        if (!loggerData.found) {
            return;
        }
        String loggerOutput = loggerData.sectionTag;
        InternalLogger.INSTANCE.initialize(loggerOutput, loggerData.items);
    }

    private boolean setChannel(ConfigFileParser parser, TelemetryConfiguration configuration) {
        TelemetryChannel channel;
        String channelName;
        ConfigFileParser.StructuredDataResult channelData = parser.getStructuredData(CHANNEL_SECTION, CLASS_TYPE_AS_ATTRIBUTE);
        if (channelData.found && (channelName = channelData.sectionTag) != null && (channel = this.createInstance(channelName, TelemetryChannel.class, Map.class, channelData.items)) != null) {
            configuration.setChannel(channel);
            return true;
        }
        try {
            configuration.setChannel(new InProcessTelemetryChannel(channelData.items));
            return true;
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to create InProcessTelemetryChannel, exception: %s, will create the default one with default arguments", e.getMessage());
            configuration.setChannel(new InProcessTelemetryChannel());
            return true;
        }
    }

    private boolean setInstrumentationKey(ConfigFileParser parser, TelemetryConfiguration configuration) {
        try {
            String iKey = parser.getTrimmedValue(INSTRUMENTATION_KEY_SECTION);
            configuration.setInstrumentationKey(iKey);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void setContextInitializers(ConfigFileParser parser, TelemetryConfiguration configuration) {
        List<ContextInitializer> initializerList = configuration.getContextInitializers();
        initializerList.add(new SdkVersionContextInitializer());
        initializerList.add(new DeviceInfoContextInitializer());
        this.loadComponents(ContextInitializer.class, parser, CONTEXT_INITIALIZERS_SECTION, INITIALIZERS_ADD, initializerList);
    }

    private void setTelemetryInitializers(ConfigFileParser parser, TelemetryConfiguration configuration) {
        List<TelemetryInitializer> initializerList = configuration.getTelemetryInitializers();
        this.loadComponents(TelemetryInitializer.class, parser, TELEMETRY_INITIALIZERS_SECTION, INITIALIZERS_ADD, initializerList);
    }

    private void setTelemetryModules(ConfigFileParser parser, TelemetryConfiguration configuration) {
        List<TelemetryModule> modules = configuration.getTelemetryModules();
        this.loadComponents(TelemetryModule.class, parser, TELEMETRY_MODULES_SECTION, INITIALIZERS_ADD, modules);
    }

    private boolean fetchBooleanValue(ConfigFileParser parser, String tagName, boolean defaultValue) {
        boolean result = defaultValue;
        String value = parser.getTrimmedValue(tagName);
        if (!Strings.isNullOrEmpty((String)value)) {
            result = Boolean.valueOf(value);
        }
        return result;
    }

    private <T> void loadComponents(Class<T> clazz, ConfigFileParser parser, String sectionName, String itemName, List<T> list) {
        Collection<String> classNames = parser.getList(sectionName, itemName, CLASS_TYPE_AS_ATTRIBUTE);
        for (String className : classNames) {
            T initializer = this.createInstance(className, clazz);
            if (initializer == null) continue;
            list.add(initializer);
        }
    }

    private <T> T createInstance(String className, Class<T> interfaceClass) {
        try {
            if (Strings.isNullOrEmpty((String)className)) {
                return null;
            }
            Class<T> clazz = Class.forName(className).asSubclass(interfaceClass);
            T instance = clazz.newInstance();
            return instance;
        }
        catch (ClassCastException e) {
            InternalLogger.INSTANCE.error("Failed to create %s, %s", className, e.getMessage());
        }
        catch (ClassNotFoundException e) {
            InternalLogger.INSTANCE.error("Failed to create %s, %s", className, e.getMessage());
        }
        catch (InstantiationException e) {
            InternalLogger.INSTANCE.error("Failed to create %s, %s", className, e.getMessage());
        }
        catch (IllegalAccessException e) {
            InternalLogger.INSTANCE.error("Failed to create %s, %s", className, e.getMessage());
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to create %s, %s", className, e.getMessage());
        }
        return null;
    }

    private <T, A> T createInstance(String className, Class<T> interfaceClass, Class<A> argumentClass, A argument) {
        try {
            if (Strings.isNullOrEmpty((String)className)) {
                return null;
            }
            Class<T> clazz = Class.forName(className).asSubclass(interfaceClass);
            Constructor<T> clazzConstructor = clazz.getConstructor(argumentClass);
            T instance = clazzConstructor.newInstance(argument);
            return instance;
        }
        catch (ClassCastException e) {
            InternalLogger.INSTANCE.error("Failed to create %s, %s", className, e.getMessage());
        }
        catch (ClassNotFoundException e) {
            InternalLogger.INSTANCE.error("Failed to create %s, %s", className, e.getMessage());
        }
        catch (InstantiationException e) {
            InternalLogger.INSTANCE.error("Failed to create %s, %s", className, e.getMessage());
        }
        catch (IllegalAccessException e) {
            InternalLogger.INSTANCE.error("Failed to create %s, %s", className, e.getMessage());
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to create %s, %s", className, e.getMessage());
        }
        return null;
    }

    private void initializeComponents(TelemetryConfiguration configuration) {
        List<TelemetryModule> telemetryModules = configuration.getTelemetryModules();
        for (TelemetryModule module : telemetryModules) {
            try {
                module.initialize(configuration);
            }
            catch (Exception e) {
                InternalLogger.INSTANCE.error("Failed to initialized telemetry module " + module.getClass().getSimpleName() + ". Excepption", new Object[0]);
            }
        }
    }
}

