/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.internal.channel.TelemetriesTransmitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class TelemetryBuffer {
    private final TelemetriesTransmitter sender;
    private int maxTelemetriesInBatch;
    private int transmitBufferTimeoutInSeconds;
    private List<String> telemetries;
    private long generation = 0L;
    private final Object lock = new Object();

    public TelemetryBuffer(TelemetriesTransmitter sender, int maxTelemetriesInBatch, int transmitBufferTimeoutInSeconds) {
        Preconditions.checkNotNull((Object)sender, (Object)"sender must be non-null value");
        Preconditions.checkArgument((maxTelemetriesInBatch > 0 ? 1 : 0) != 0, (Object)"maxTelemetriesInBatch must be a positive number");
        Preconditions.checkArgument((transmitBufferTimeoutInSeconds > 0 ? 1 : 0) != 0, (Object)"transmitBufferTimeoutInSeconds must be a positive number");
        this.setMaxTelemetriesInBatch(maxTelemetriesInBatch);
        this.sender = sender;
        this.telemetries = new ArrayList<String>(this.maxTelemetriesInBatch);
        this.transmitBufferTimeoutInSeconds = transmitBufferTimeoutInSeconds;
    }

    public void setMaxTelemetriesInBatch(int maxTelemetriesInBatch) {
        this.maxTelemetriesInBatch = maxTelemetriesInBatch;
    }

    public int getMaxTelemetriesInBatch() {
        return this.maxTelemetriesInBatch;
    }

    public void setTransmitBufferTimeoutInSeconds(int transmitBufferTimeoutInSeconds) {
        this.transmitBufferTimeoutInSeconds = transmitBufferTimeoutInSeconds;
    }

    public int getTransmitBufferTimeoutInSeconds() {
        return this.transmitBufferTimeoutInSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String telemetry) {
        Preconditions.checkNotNull((Object)telemetry, (Object)"Telemetry must be non null value");
        Object object = this.lock;
        synchronized (object) {
            this.telemetries.add(telemetry);
            int currentSize = this.telemetries.size();
            if (currentSize >= this.maxTelemetriesInBatch) {
                if (!this.sender.sendNow(this.prepareTelemetriesForSend())) {
                    // empty if block
                }
            } else if (currentSize == 1 && !this.sender.scheduleSend(new TelemetryBufferTelemetriesFetcher(this.generation), this.transmitBufferTimeoutInSeconds, TimeUnit.SECONDS)) {
                this.telemetries.clear();
            }
        }
    }

    private List<String> prepareTelemetriesForSend() {
        ++this.generation;
        List<String> readyToBeSent = this.telemetries;
        this.telemetries = new ArrayList<String>(this.maxTelemetriesInBatch);
        return readyToBeSent;
    }

    private final class TelemetryBufferTelemetriesFetcher
    implements TelemetriesTransmitter.TelemetriesFetcher {
        private final long expectedGeneration;

        private TelemetryBufferTelemetriesFetcher(long expectedGeneration) {
            this.expectedGeneration = expectedGeneration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<String> fetch() {
            Object object = TelemetryBuffer.this.lock;
            synchronized (object) {
                if (this.expectedGeneration != TelemetryBuffer.this.generation) {
                    return Collections.emptyList();
                }
                ++TelemetryBuffer.this.generation;
                List readyToBeSent = TelemetryBuffer.this.telemetries;
                TelemetryBuffer.this.telemetries = new ArrayList();
                return readyToBeSent;
            }
        }
    }
}

