/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.channel.concrete.inprocess;

import com.microsoft.applicationinsights.internal.channel.TelemetriesTransmitter;
import com.microsoft.applicationinsights.internal.channel.TransmissionOutput;
import com.microsoft.applicationinsights.internal.channel.TransmitterFactory;
import com.microsoft.applicationinsights.internal.channel.common.ActiveTransmissionFileSystemOutput;
import com.microsoft.applicationinsights.internal.channel.common.ActiveTransmissionLoader;
import com.microsoft.applicationinsights.internal.channel.common.ActiveTransmissionNetworkOutput;
import com.microsoft.applicationinsights.internal.channel.common.GzipTelemetrySerializer;
import com.microsoft.applicationinsights.internal.channel.common.NonBlockingDispatcher;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionFileSystemOutput;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionNetworkOutput;
import com.microsoft.applicationinsights.internal.channel.common.TransmitterImpl;

final class InProcessTelemetryChannelFactory
implements TransmitterFactory {
    InProcessTelemetryChannelFactory() {
    }

    @Override
    public TelemetriesTransmitter create(String endpoint) {
        TransmissionNetworkOutput actualNetworkSender = TransmissionNetworkOutput.create(endpoint);
        ActiveTransmissionNetworkOutput networkSender = new ActiveTransmissionNetworkOutput(actualNetworkSender);
        TransmissionFileSystemOutput fileSystemSender = new TransmissionFileSystemOutput();
        ActiveTransmissionFileSystemOutput activeFileSystemOutput = new ActiveTransmissionFileSystemOutput(fileSystemSender);
        NonBlockingDispatcher dispatcher = new NonBlockingDispatcher(new TransmissionOutput[]{networkSender, activeFileSystemOutput});
        actualNetworkSender.setTransmissionDispatcher(dispatcher);
        ActiveTransmissionLoader transmissionsLoader = new ActiveTransmissionLoader(fileSystemSender, dispatcher);
        TransmitterImpl telemetriesTransmitter = new TransmitterImpl(dispatcher, new GzipTelemetrySerializer(), transmissionsLoader);
        return telemetriesTransmitter;
    }
}

