/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.channel.concrete.inprocess;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.channel.concrete.inprocess.InProcessTelemetryChannelFactory;
import com.microsoft.applicationinsights.internal.channel.TelemetriesTransmitter;
import com.microsoft.applicationinsights.internal.channel.TransmitterFactory;
import com.microsoft.applicationinsights.internal.channel.common.TelemetryBuffer;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.JsonTelemetryDataSerializer;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class InProcessTelemetryChannel
implements TelemetryChannel {
    private static final int DEFAULT_NUMBER_OF_TELEMETRIES_PER_CONTAINER = 500;
    private static final int TRANSMIT_BUFFER_DEFAULT_TIMEOUT_IN_SECONDS = 10;
    private static final String DEVELOPER_MODE = "DeveloperMode";
    private static final String EndpointAddress = "EndpointAddress";
    private boolean developerMode = false;
    private static TransmitterFactory s_transmitterFactory;
    private boolean stopped = false;
    private TelemetriesTransmitter telemetriesTransmitter;
    private TelemetryBuffer telemetryBuffer;

    public InProcessTelemetryChannel() {
        this(null, false);
    }

    public InProcessTelemetryChannel(String endpointAddress, boolean developerMode) {
        this.initialize(endpointAddress, developerMode);
    }

    public InProcessTelemetryChannel(Map<String, String> nameAndValues) {
        boolean developerMode = false;
        String endpointAddress = null;
        if (nameAndValues != null) {
            developerMode = Boolean.valueOf(nameAndValues.get(DEVELOPER_MODE));
            endpointAddress = nameAndValues.get(EndpointAddress);
        }
        this.initialize(endpointAddress, developerMode);
    }

    @Override
    public boolean isDeveloperMode() {
        return this.developerMode;
    }

    @Override
    public void setDeveloperMode(boolean developerMode) {
        if (developerMode != this.developerMode) {
            this.developerMode = developerMode;
            int maxTelemetriesInBatch = this.developerMode ? 1 : 500;
            this.telemetryBuffer.setMaxTelemetriesInBatch(maxTelemetriesInBatch);
        }
    }

    @Override
    public void send(Telemetry telemetry) {
        Preconditions.checkNotNull((Object)telemetry, (Object)"Telemetry item must be non null");
        if (this.isDeveloperMode()) {
            telemetry.getContext().getProperties().put(DEVELOPER_MODE, "true");
        }
        StringWriter writer = new StringWriter();
        JsonTelemetryDataSerializer jsonWriter = null;
        try {
            jsonWriter = new JsonTelemetryDataSerializer(writer);
            telemetry.serialize(jsonWriter);
            jsonWriter.close();
            String asJson = writer.toString();
            this.telemetryBuffer.add(asJson);
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Failed to serialize Telemetry", new Object[0]);
            return;
        }
        if (this.isDeveloperMode()) {
            this.writeTelemetryToDebugOutput(telemetry);
        }
    }

    @Override
    public synchronized void stop(long timeout, TimeUnit timeUnit) {
        try {
            if (this.stopped) {
                return;
            }
            this.telemetriesTransmitter.stop(timeout, timeUnit);
            this.stopped = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    private void writeTelemetryToDebugOutput(Telemetry telemetry) {
        InternalLogger.INSTANCE.trace("InProcessTelemetryChannel sending telemetry", new Object[0]);
    }

    private synchronized void initialize(String endpointAddress, boolean developerMode) {
        this.makeSureEndpointAddressIsValid(endpointAddress);
        if (s_transmitterFactory == null) {
            s_transmitterFactory = new InProcessTelemetryChannelFactory();
        }
        this.telemetriesTransmitter = s_transmitterFactory.create(endpointAddress);
        this.telemetryBuffer = new TelemetryBuffer(this.telemetriesTransmitter, 500, 10);
        this.setDeveloperMode(developerMode);
    }

    private void makeSureEndpointAddressIsValid(String endpointAddress) {
        if (Strings.isNullOrEmpty((String)endpointAddress)) {
            return;
        }
        URI uri = Sanitizer.sanitizeUri(endpointAddress);
        if (uri == null) {
            String errorMessage = String.format("Endpoint address %s is not a valid uri", endpointAddress);
            InternalLogger.INSTANCE.error(errorMessage, new Object[0]);
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

