/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.internal;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.bootstrap.internal.EmptyInstrumentationConfig;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class InstrumentationConfig {
    private static final PatchLogger logger = PatchLogger.getLogger(InstrumentationConfig.class.getName());
    private static final InstrumentationConfig DEFAULT;
    private static volatile InstrumentationConfig instance;

    public static void internalInitializeConfig(InstrumentationConfig config) {
        if (instance != DEFAULT) {
            logger.warning("InstrumentationConfig#instance was already set earlier");
            return;
        }
        instance = Objects.requireNonNull(config);
    }

    public static InstrumentationConfig get() {
        return instance;
    }

    @Nullable
    public abstract String getString(String var1);

    public abstract String getString(String var1, String var2);

    public abstract boolean getBoolean(String var1, boolean var2);

    public abstract int getInt(String var1, int var2);

    public abstract long getLong(String var1, long var2);

    public abstract double getDouble(String var1, double var2);

    public abstract Duration getDuration(String var1, Duration var2);

    public List<String> getList(String name) {
        return this.getList(name, Collections.emptyList());
    }

    public abstract List<String> getList(String var1, List<String> var2);

    public abstract Map<String, String> getMap(String var1, Map<String, String> var2);

    static {
        instance = DEFAULT = new EmptyInstrumentationConfig();
    }
}

