/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.cache.Cache;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class HelperResources {
    private static final Cache<ClassLoader, Map<String, List<URL>>> RESOURCES = Cache.weak();
    private static final Map<String, List<URL>> ALL_CLASSLOADERS_RESOURCES = new ConcurrentHashMap<String, List<URL>>();

    public static void register(ClassLoader classLoader, String path, List<URL> urls) {
        RESOURCES.computeIfAbsent(classLoader, unused -> new ConcurrentHashMap()).compute(path, (k, v) -> HelperResources.append(v, urls));
    }

    public static void registerForAllClassLoaders(String path, List<URL> urls) {
        ALL_CLASSLOADERS_RESOURCES.compute(path, (k, v) -> HelperResources.append(v, urls));
    }

    private static List<URL> append(@Nullable List<URL> resources, List<URL> toAdd) {
        ArrayList<URL> newResources = resources == null ? new ArrayList<URL>() : new ArrayList<URL>(resources);
        for (URL newResource : toAdd) {
            if (HelperResources.containsSameFile(newResources, newResource)) continue;
            newResources.add(newResource);
        }
        return Collections.unmodifiableList(newResources);
    }

    private static boolean containsSameFile(List<URL> haystack, URL needle) {
        for (URL r : haystack) {
            if (!r.sameFile(needle)) continue;
            return true;
        }
        return false;
    }

    public static URL loadOne(ClassLoader classLoader, String path) {
        List<URL> resources = HelperResources.loadAll(classLoader, path);
        return resources.isEmpty() ? null : resources.get(0);
    }

    public static List<URL> loadAll(ClassLoader classLoader, String path) {
        Map<String, List<URL>> map = RESOURCES.get(classLoader);
        List<URL> resources = null;
        if (map != null) {
            resources = map.get(path);
        }
        if (resources == null) {
            resources = ALL_CLASSLOADERS_RESOURCES.get(path);
        }
        return resources == null ? Collections.emptyList() : resources;
    }

    private HelperResources() {
    }
}

