/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.TimeUnit;

final class StartupProfiler {
    public static void start() {
        PrintWriter printWriter;
        String tempDirectory = System.getProperty("java.io.tmpdir");
        File folder = new File(tempDirectory, "applicationinsights");
        if (!folder.exists() && !folder.mkdirs()) {
            System.out.println("Failed to create directory: " + tempDirectory);
            return;
        }
        File dumpFile = new File(folder, StartupProfiler.getThreadDumpFilename());
        System.out.println("Writing startup profiler to '" + dumpFile.getPath() + "'");
        try {
            printWriter = new PrintWriter(Files.newBufferedWriter(dumpFile.toPath(), Charset.defaultCharset(), new OpenOption[0]));
        }
        catch (IOException e) {
            System.out.println("Error occurred when writing dump to " + dumpFile.getPath());
            e.printStackTrace();
            return;
        }
        StartupProfiler.start(printWriter);
    }

    private static void start(PrintWriter out) {
        Thread thread = new Thread((Runnable)new ThreadDump(out), "StartupProfiler");
        thread.setDaemon(true);
        thread.start();
    }

    private static String getThreadDumpFilename() {
        return "stacktrace-" + System.currentTimeMillis() + ".txt";
    }

    private StartupProfiler() {
    }

    private static class ThreadDump
    implements Runnable {
        private final PrintWriter out;

        private ThreadDump(PrintWriter out) {
            this.out = out;
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() - start < TimeUnit.MINUTES.toMillis(10L)) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    System.out.println("Startup profiler interrupted");
                    return;
                }
                this.captureThreadDump();
            }
        }

        private void captureThreadDump() {
            this.out.println("========================================");
            RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
            this.out.print("uptime: ");
            this.out.println(runtimeBean.getUptime());
            this.out.println();
            ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
            ThreadInfo[] threadInfos = threadBean.getThreadInfo(threadBean.getAllThreadIds(), threadBean.isObjectMonitorUsageSupported(), false);
            long currentThreadId = Thread.currentThread().getId();
            for (ThreadInfo threadInfo : threadInfos) {
                if (threadInfo == null || threadInfo.getThreadId() == currentThreadId) continue;
                this.write(threadInfo);
            }
            this.out.flush();
        }

        private void write(ThreadInfo threadInfo) {
            this.out.println(threadInfo.getThreadName() + " #" + threadInfo.getThreadId());
            this.out.println("   java.lang.Thread.State: " + (Object)((Object)threadInfo.getThreadState()));
            for (StackTraceElement ste : threadInfo.getStackTrace()) {
                this.out.println("        " + ste);
            }
            this.out.println();
        }
    }
}

