/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent;

import com.microsoft.applicationinsights.agent.StartupProfiler;
import io.opentelemetry.javaagent.OpenTelemetryAgent;
import java.lang.instrument.Instrumentation;
import java.util.concurrent.atomic.AtomicBoolean;

public class Agent {
    private static final AtomicBoolean alreadyLoaded = new AtomicBoolean(false);

    public static void premain(String agentArgs, Instrumentation inst) {
        if (alreadyLoaded.getAndSet(true)) {
            return;
        }
        if (Boolean.getBoolean("applicationinsights.debug.startupProfiling")) {
            StartupProfiler.start();
        }
        System.setProperty("otel.javaagent.logging", "applicationinsights");
        OpenTelemetryAgent.premain(agentArgs, inst);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        Agent.premain(agentArgs, inst);
    }

    public static void main(String ... args) {
        System.err.println("*************************\nApplication Insights Java agent should be attached to an existing Java application using the -javaagent flag.\n*************************\n\nFor more information, see https://learn.microsoft.com/azure/azure-monitor/app/opentelemetry-enable?tabs=java#modify-your-application\n");
    }

    private Agent() {
    }
}

