/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.shadow.com.squareup.moshi;

import com.microsoft.applicationinsights.agent.shadow.okio.Buffer;
import com.microsoft.applicationinsights.agent.shadow.okio.BufferedSource;
import com.microsoft.applicationinsights.agent.shadow.okio.ByteString;
import com.microsoft.applicationinsights.agent.shadow.okio.Source;
import com.microsoft.applicationinsights.agent.shadow.okio.Timeout;
import java.io.IOException;

final class JsonValueSource
implements Source {
    static final ByteString STATE_JSON = ByteString.encodeUtf8("[]{}\"'/#");
    static final ByteString STATE_SINGLE_QUOTED = ByteString.encodeUtf8("'\\");
    static final ByteString STATE_DOUBLE_QUOTED = ByteString.encodeUtf8("\"\\");
    static final ByteString STATE_END_OF_LINE_COMMENT = ByteString.encodeUtf8("\r\n");
    static final ByteString STATE_C_STYLE_COMMENT = ByteString.encodeUtf8("*");
    static final ByteString STATE_END_OF_JSON = ByteString.EMPTY;
    private final BufferedSource source;
    private final Buffer buffer;
    private final Buffer prefix;
    private ByteString state;
    private int stackSize;
    private long limit = 0L;
    private boolean closed = false;

    JsonValueSource(BufferedSource source) {
        this(source, new Buffer(), STATE_JSON, 0);
    }

    JsonValueSource(BufferedSource source, Buffer prefix, ByteString state, int stackSize) {
        this.source = source;
        this.buffer = source.getBuffer();
        this.prefix = prefix;
        this.state = state;
        this.stackSize = stackSize;
    }

    private void advanceLimit(long byteCount) throws IOException {
        while (this.limit < byteCount) {
            long index;
            if (this.state == STATE_END_OF_JSON) {
                return;
            }
            if (this.limit == this.buffer.size()) {
                if (this.limit > 0L) {
                    return;
                }
                this.source.require(1L);
            }
            if ((index = this.buffer.indexOfElement(this.state, this.limit)) == -1L) {
                this.limit = this.buffer.size();
                continue;
            }
            byte b = this.buffer.getByte(index);
            if (this.state == STATE_JSON) {
                switch (b) {
                    case 91: 
                    case 123: {
                        ++this.stackSize;
                        this.limit = index + 1L;
                        break;
                    }
                    case 93: 
                    case 125: {
                        --this.stackSize;
                        if (this.stackSize == 0) {
                            this.state = STATE_END_OF_JSON;
                        }
                        this.limit = index + 1L;
                        break;
                    }
                    case 34: {
                        this.state = STATE_DOUBLE_QUOTED;
                        this.limit = index + 1L;
                        break;
                    }
                    case 39: {
                        this.state = STATE_SINGLE_QUOTED;
                        this.limit = index + 1L;
                        break;
                    }
                    case 47: {
                        this.source.require(index + 2L);
                        byte b2 = this.buffer.getByte(index + 1L);
                        if (b2 == 47) {
                            this.state = STATE_END_OF_LINE_COMMENT;
                            this.limit = index + 2L;
                            break;
                        }
                        if (b2 == 42) {
                            this.state = STATE_C_STYLE_COMMENT;
                            this.limit = index + 2L;
                            break;
                        }
                        this.limit = index + 1L;
                        break;
                    }
                    case 35: {
                        this.state = STATE_END_OF_LINE_COMMENT;
                        this.limit = index + 1L;
                    }
                }
                continue;
            }
            if (this.state == STATE_SINGLE_QUOTED || this.state == STATE_DOUBLE_QUOTED) {
                if (b == 92) {
                    this.source.require(index + 2L);
                    this.limit = index + 2L;
                    continue;
                }
                this.state = this.stackSize > 0 ? STATE_JSON : STATE_END_OF_JSON;
                this.limit = index + 1L;
                continue;
            }
            if (this.state == STATE_C_STYLE_COMMENT) {
                this.source.require(index + 2L);
                if (this.buffer.getByte(index + 1L) == 47) {
                    this.limit = index + 2L;
                    this.state = STATE_JSON;
                    continue;
                }
                this.limit = index + 1L;
                continue;
            }
            if (this.state == STATE_END_OF_LINE_COMMENT) {
                this.limit = index + 1L;
                this.state = STATE_JSON;
                continue;
            }
            throw new AssertionError();
        }
    }

    public void discard() throws IOException {
        this.closed = true;
        while (this.state != STATE_END_OF_JSON) {
            this.advanceLimit(8192L);
            this.source.skip(this.limit);
        }
    }

    @Override
    public long read(Buffer sink, long byteCount) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (byteCount == 0L) {
            return 0L;
        }
        if (!this.prefix.exhausted()) {
            long prefixResult = this.prefix.read(sink, byteCount);
            byteCount -= prefixResult;
            if (this.buffer.exhausted()) {
                return prefixResult;
            }
            long suffixResult = this.read(sink, byteCount);
            return suffixResult != -1L ? suffixResult + prefixResult : prefixResult;
        }
        this.advanceLimit(byteCount);
        if (this.limit == 0L) {
            if (this.state != STATE_END_OF_JSON) {
                throw new AssertionError();
            }
            return -1L;
        }
        long result = Math.min(byteCount, this.limit);
        sink.write(this.buffer, result);
        this.limit -= result;
        return result;
    }

    @Override
    public Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

