/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.bootstrap.diagnostics.etw;

import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.ApplicationMetadataFactory;
import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.DiagnosticsHelper;
import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.MsgId;
import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.etw.ApplicationInsightsEtwException;
import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.etw.EtwProvider;
import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.etw.events.IpaError;
import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.etw.events.IpaInfo;
import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.etw.events.IpaVerbose;
import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.etw.events.IpaWarn;
import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.etw.events.model.IpaEtwEventBase;
import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.status.StatusFile;
import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.classic.Level;
import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.classic.spi.ILoggingEvent;
import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.classic.spi.ThrowableProxyUtil;
import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.core.AppenderBase;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.Map;

public class EtwAppender
extends AppenderBase<ILoggingEvent> {
    private final EtwProvider etwProvider;
    private final IpaEtwEventBase proto;

    public EtwAppender() {
        ApplicationMetadataFactory metadata = DiagnosticsHelper.getMetadataFactory();
        this.proto = new IpaInfo();
        this.proto.setAppName(metadata.getSiteName().getValue());
        this.proto.setExtensionVersion(metadata.getSdkVersion().getValue());
        this.proto.setSubscriptionId(metadata.getSubscriptionId().getValue());
        this.proto.setInstrumentationKey(metadata.getInstrumentationKey().getValue());
        this.etwProvider = new EtwProvider(metadata.getSdkVersion().getValue());
    }

    @Override
    public void start() {
        IpaVerbose event = new IpaVerbose(this.proto);
        event.setMessageFormat("EtwProvider initialized successfully.");
        event.setMsgId(MsgId.INITIALIZATION_SUCCESS.getValue());
        try {
            this.etwProvider.writeEvent(event);
        }
        catch (ApplicationInsightsEtwException | LinkageError e) {
            String message = "EtwProvider failed to initialize.";
            LoggerFactory.getLogger("applicationinsights.extension.diagnostics").error(message, e);
            this.addError(message, e);
            StatusFile.putValue("EtwProviderInitialized", "false");
            StatusFile.putValue("EtwProviderError", e.getLocalizedMessage());
            StatusFile.write();
            return;
        }
        StatusFile.putValueAndWrite("EtwProviderInitialized", "true");
        super.start();
    }

    @Override
    protected void append(ILoggingEvent logEvent) {
        IpaEtwEventBase event;
        String logger = logEvent.getLoggerName();
        if (logger != null && logger.startsWith("com.microsoft.applicationinsights.agent.bootstrap.diagnostics.etw.")) {
            this.addWarn("Skipping attempt to log to " + logger);
            return;
        }
        Level level = logEvent.getLevel();
        switch (level.levelInt) {
            case 40000: {
                IpaError error = new IpaError(this.proto);
                error.setStacktrace(ThrowableProxyUtil.asString(logEvent.getThrowableProxy()));
                event = error;
                break;
            }
            case 30000: {
                IpaWarn warn = new IpaWarn(this.proto);
                warn.setStacktrace(ThrowableProxyUtil.asString(logEvent.getThrowableProxy()));
                event = warn;
                break;
            }
            case 20000: {
                event = new IpaInfo(this.proto);
                break;
            }
            default: {
                this.addWarn("Unsupported log level: " + level.levelStr);
                return;
            }
        }
        Map<String, String> mdcPropertyMap = logEvent.getMDCPropertyMap();
        if (!mdcPropertyMap.isEmpty()) {
            String messageId;
            String operation = mdcPropertyMap.get("microsoft.ai.operationName");
            if (operation != null && !operation.isEmpty()) {
                event.setOperation(operation);
            }
            if ((messageId = mdcPropertyMap.get("msgId")) != null && !messageId.isEmpty()) {
                event.setMsgId(messageId);
            }
        }
        event.setLogger(logger);
        event.setMessageFormat(logEvent.getMessage());
        event.setMessageArgs(logEvent.getArgumentArray());
        try {
            this.etwProvider.writeEvent(event);
        }
        catch (ApplicationInsightsEtwException e) {
            this.addError("Exception from EtwProvider: " + e.getLocalizedMessage(), e);
        }
    }
}

