/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.CapturedHttpHeaders;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.ForwarderHeaderParser;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;

public abstract class HttpServerAttributesExtractor<REQUEST, RESPONSE>
extends HttpCommonAttributesExtractor<REQUEST, RESPONSE> {
    protected HttpServerAttributesExtractor(CapturedHttpHeaders capturedHttpHeaders) {
        super(capturedHttpHeaders);
    }

    protected HttpServerAttributesExtractor() {
        this(CapturedHttpHeaders.server(Config.get()));
    }

    @Override
    public final void onStart(AttributesBuilder attributes, REQUEST request) {
        super.onStart(attributes, request);
        this.set(attributes, SemanticAttributes.HTTP_FLAVOR, this.flavor(request));
        this.set(attributes, SemanticAttributes.HTTP_SCHEME, this.scheme(request));
        this.set(attributes, SemanticAttributes.HTTP_HOST, this.host(request));
        this.set(attributes, SemanticAttributes.HTTP_TARGET, this.target(request));
        this.set(attributes, SemanticAttributes.HTTP_ROUTE, this.route(request));
        this.set(attributes, SemanticAttributes.HTTP_CLIENT_IP, this.clientIp(request));
    }

    @Override
    public final void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        super.onEnd(attributes, request, response, error);
        this.set(attributes, SemanticAttributes.HTTP_SERVER_NAME, this.serverName(request, response));
    }

    @Nullable
    protected abstract String flavor(REQUEST var1);

    @Nullable
    protected abstract String target(REQUEST var1);

    @Nullable
    private String host(REQUEST request) {
        return HttpServerAttributesExtractor.firstHeaderValue(this.requestHeader(request, "host"));
    }

    @Nullable
    protected abstract String route(REQUEST var1);

    @Nullable
    protected abstract String scheme(REQUEST var1);

    @Nullable
    private String clientIp(REQUEST request) {
        String forwarded = HttpServerAttributesExtractor.firstHeaderValue(this.requestHeader(request, "forwarded"));
        if (forwarded != null && (forwarded = ForwarderHeaderParser.extractForwarded(forwarded)) != null) {
            return forwarded;
        }
        forwarded = HttpServerAttributesExtractor.firstHeaderValue(this.requestHeader(request, "x-forwarded-for"));
        if (forwarded != null) {
            return ForwarderHeaderParser.extractForwardedFor(forwarded);
        }
        return null;
    }

    @Nullable
    protected abstract String serverName(REQUEST var1, @Nullable RESPONSE var2);
}

