/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.shaded.instrumentation.api.caching.Cache;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import java.util.List;

final class HttpHeaderAttributes {
    private static final Cache<String, AttributeKey<List<String>>> requestKeysCache = Cache.builder().setMaximumSize(32L).build();
    private static final Cache<String, AttributeKey<List<String>>> responseKeysCache = Cache.builder().setMaximumSize(32L).build();

    static AttributeKey<List<String>> requestAttributeKey(String headerName) {
        return requestKeysCache.computeIfAbsent(headerName, n -> HttpHeaderAttributes.createKey("request", n));
    }

    static AttributeKey<List<String>> responseAttributeKey(String headerName) {
        return responseKeysCache.computeIfAbsent(headerName, n -> HttpHeaderAttributes.createKey("response", n));
    }

    private static AttributeKey<List<String>> createKey(String type, String headerName) {
        String key = "http." + type + ".header." + headerName.replace('-', '_');
        return AttributeKey.stringArrayKey(key);
    }

    private HttpHeaderAttributes() {
    }
}

