/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.bootstrap.diagnostics.log;

import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.ApplicationMetadataFactory;
import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.DiagnosticsHelper;
import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.DiagnosticsValueFinder;
import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.classic.spi.ILoggingEvent;
import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.contrib.json.classic.JsonLayout;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ApplicationInsightsJsonLayout
extends JsonLayout {
    public static final String TIMESTAMP_PROP_NAME = "time";
    public static final String OPERATION_NAME_PROP_NAME = "operation";
    public static final String CUSTOM_FIELDS_PROP_NAME = "properties";
    static final String UNKNOWN_VALUE = "unknown";
    final List<DiagnosticsValueFinder> valueFinders = new ArrayList<DiagnosticsValueFinder>();

    public ApplicationInsightsJsonLayout() {
        ApplicationMetadataFactory mf = DiagnosticsHelper.getMetadataFactory();
        this.valueFinders.add(mf.getSiteName());
        this.valueFinders.add(mf.getInstrumentationKey());
        this.valueFinders.add(mf.getExtensionVersion());
        this.valueFinders.add(mf.getSdkVersion());
        this.valueFinders.add(mf.getSubscriptionId());
    }

    @Override
    protected Map toJsonMap(ILoggingEvent event) {
        LinkedHashMap<String, Object> jsonMap = new LinkedHashMap<String, Object>();
        this.addTimestamp(TIMESTAMP_PROP_NAME, true, event.getTimeStamp(), jsonMap);
        this.add("level", true, String.valueOf(event.getLevel()), jsonMap);
        this.add("logger", true, event.getLoggerName(), jsonMap);
        this.add("message", true, event.getFormattedMessage(), jsonMap);
        this.addThrowableInfo("exception", true, event, jsonMap);
        this.addMap(CUSTOM_FIELDS_PROP_NAME, true, this.getPropertiesMap(event), jsonMap);
        return jsonMap;
    }

    private Map<String, Object> getPropertiesMap(ILoggingEvent event) {
        LinkedHashMap<String, Object> jsonMap = new LinkedHashMap<String, Object>();
        this.add(OPERATION_NAME_PROP_NAME, true, this.getOperationName(event), jsonMap);
        for (DiagnosticsValueFinder finder : this.valueFinders) {
            String value = finder.getValue();
            this.add(finder.getName(), true, value == null || value.isEmpty() ? UNKNOWN_VALUE : value, jsonMap);
        }
        jsonMap.put("language", "java");
        return jsonMap;
    }

    public String getOperationName(ILoggingEvent event) {
        return event.getMDCPropertyMap().get("microsoft.ai.operationName");
    }
}

