/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.bootstrap.diagnostics.etw.events.model;

import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.etw.events.model.IpaEtwEvent;

public abstract class IpaEtwEventBase
implements IpaEtwEvent {
    private String extensionVersion;
    private String appName;
    private String instrumentationKey;
    private String subscriptionId;
    private String logger;
    private String messageFormat;
    private Object[] messageArgs = new Object[0];
    private String operation;

    protected IpaEtwEventBase() {
    }

    protected IpaEtwEventBase(IpaEtwEventBase event) {
        this.extensionVersion = event.extensionVersion;
        this.appName = event.appName;
        this.instrumentationKey = event.instrumentationKey;
        this.subscriptionId = event.subscriptionId;
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    public String getExtensionVersion() {
        return this.extensionVersion == null ? "" : this.extensionVersion;
    }

    public void setExtensionVersion(String extensionVersion) {
        this.extensionVersion = extensionVersion;
    }

    public String getAppName() {
        return this.appName == null ? "" : this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getSubscriptionId() {
        return this.subscriptionId == null ? "" : this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public void setMessageFormat(String messageFormat) {
        this.messageFormat = messageFormat;
    }

    public void setMessageArgs(Object ... messageArgs) {
        this.messageArgs = messageArgs;
    }

    public String getFormattedMessage() {
        String fmt = this.processMessageFormat();
        if (this.messageArgs == null || this.messageArgs.length == 0) {
            return fmt == null ? "" : fmt;
        }
        return String.format(fmt, this.messageArgs);
    }

    protected String processMessageFormat() {
        if (this.logger != null && !this.logger.isEmpty()) {
            String prefix = "[" + this.logger;
            if (this.operation != null && !this.operation.isEmpty()) {
                prefix = prefix + "/" + this.operation;
            }
            prefix = prefix + "] ";
            return prefix + this.messageFormat;
        }
        if (this.operation != null && !this.operation.isEmpty()) {
            return "[-/" + this.operation + "] " + this.messageFormat;
        }
        return this.messageFormat;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }
}

