/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeType;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AttributeKeyImpl<T>
implements AttributeKey<T> {
    private final AttributeType type;
    private final String key;
    private final int hashCode;

    private AttributeKeyImpl(AttributeType type, String key) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type;
        if (key == null) {
            throw new NullPointerException("Null key");
        }
        this.key = key;
        this.hashCode = this.buildHashCode();
    }

    static <T> AttributeKey<T> create(@Nullable String key, AttributeType type) {
        return new AttributeKeyImpl<T>(type, key != null ? key : "");
    }

    @Override
    public AttributeType getType() {
        return this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AttributeKeyImpl) {
            AttributeKeyImpl that = (AttributeKeyImpl)o;
            return this.type.equals((Object)that.getType()) && this.key.equals(that.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.key;
    }

    private int buildHashCode() {
        int result = 1;
        result *= 1000003;
        result ^= this.type.hashCode();
        result *= 1000003;
        return result ^= this.key.hashCode();
    }
}

