/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.CompositeSuppressionStrategy;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.NoopSuppressionStrategy;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SuppressIfSameSpanKeyStrategy;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.Collections;
import java.util.Set;

abstract class SpanSuppressionStrategy {
    private static final SpanSuppressionStrategy SERVER_STRATEGY = new SuppressIfSameSpanKeyStrategy(Collections.singleton(SpanKey.SERVER));
    private static final SpanSuppressionStrategy ALL_CLIENTS_STRATEGY = new SuppressIfSameSpanKeyStrategy(Collections.singleton(SpanKey.ALL_CLIENTS));
    private static final SpanSuppressionStrategy SUPPRESS_GENERIC_CLIENTS_AND_SERVERS = new CompositeSuppressionStrategy(ALL_CLIENTS_STRATEGY, NoopSuppressionStrategy.INSTANCE, SERVER_STRATEGY, NoopSuppressionStrategy.INSTANCE);
    private static final SpanSuppressionStrategy SUPPRESS_ONLY_SERVERS = new CompositeSuppressionStrategy(NoopSuppressionStrategy.INSTANCE, NoopSuppressionStrategy.INSTANCE, SERVER_STRATEGY, NoopSuppressionStrategy.INSTANCE);

    SpanSuppressionStrategy() {
    }

    static SpanSuppressionStrategy suppressNestedClients(Set<SpanKey> spanKeys) {
        if (spanKeys.isEmpty()) {
            return SUPPRESS_GENERIC_CLIENTS_AND_SERVERS;
        }
        SuppressIfSameSpanKeyStrategy spanKeyStrategy = new SuppressIfSameSpanKeyStrategy(spanKeys);
        return new CompositeSuppressionStrategy(ALL_CLIENTS_STRATEGY, spanKeyStrategy, SERVER_STRATEGY, spanKeyStrategy);
    }

    static SpanSuppressionStrategy from(Set<SpanKey> spanKeys) {
        if (spanKeys.isEmpty()) {
            return SUPPRESS_ONLY_SERVERS;
        }
        SuppressIfSameSpanKeyStrategy spanKeyStrategy = new SuppressIfSameSpanKeyStrategy(spanKeys);
        return new CompositeSuppressionStrategy(spanKeyStrategy, spanKeyStrategy, SERVER_STRATEGY, spanKeyStrategy);
    }

    abstract Context storeInContext(Context var1, SpanKind var2, Span var3);

    abstract boolean shouldSuppress(Context var1, SpanKind var2);
}

