/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.bootstrap;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aisdk.MicrometerUtil;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class BytecodeUtil {
    private static BytecodeUtilDelegate delegate;
    private static final ThreadLocal<Long> startNanosHolder;

    public static void setDelegate(final BytecodeUtilDelegate delegate) {
        if (BytecodeUtil.delegate == null) {
            BytecodeUtil.delegate = delegate;
            MicrometerUtil.setDelegate(new MicrometerUtil.MicrometerUtilDelegate(){

                @Override
                public void trackMetric(String name, double value, Integer count, Double min, Double max, Map<String, String> properties) {
                    delegate.trackMetric(null, name, value, count, min, max, null, properties, Collections.emptyMap(), null);
                }
            });
        }
    }

    public static void trackEvent(Date timestamp, String name, Map<String, String> properties, Map<String, String> tags, Map<String, Double> metrics, String instrumentationKey) {
        if (delegate != null) {
            delegate.trackEvent(timestamp, name, properties, tags, metrics, instrumentationKey);
        }
    }

    public static void trackMetric(Date timestamp, String name, double value, Integer count, Double min, Double max, Double stdDev, Map<String, String> properties, Map<String, String> tags, String instrumentationKey) {
        if (delegate != null) {
            delegate.trackMetric(timestamp, name, value, count, min, max, stdDev, properties, tags, instrumentationKey);
        }
    }

    public static void trackDependency(Date timestamp, String name, String id, String resultCode, Long totalMillis, boolean success, String commandName, String type, String target, Map<String, String> properties, Map<String, String> tags, Map<String, Double> metrics, String instrumentationKey) {
        if (delegate != null) {
            delegate.trackDependency(timestamp, name, id, resultCode, totalMillis, success, commandName, type, target, properties, tags, metrics, instrumentationKey);
        }
    }

    public static void trackPageView(Date timestamp, String name, URI uri, long totalMillis, Map<String, String> properties, Map<String, String> tags, Map<String, Double> metrics, String instrumentationKey) {
        if (delegate != null) {
            delegate.trackPageView(timestamp, name, uri, totalMillis, properties, tags, metrics, instrumentationKey);
        }
    }

    public static void trackTrace(Date timestamp, String message, int severityLevel, Map<String, String> properties, Map<String, String> tags, String instrumentationKey) {
        if (delegate != null) {
            delegate.trackTrace(timestamp, message, severityLevel, properties, tags, instrumentationKey);
        }
    }

    public static void trackRequest(String id, String name, URL url, Date timestamp, Long duration, String responseCode, boolean success, String source, Map<String, String> properties, Map<String, String> tags, Map<String, Double> metrics, String instrumentationKey) {
        if (delegate != null) {
            delegate.trackRequest(id, name, url, timestamp, duration, responseCode, success, source, properties, tags, metrics, instrumentationKey);
        }
    }

    public static void trackException(Date timestamp, Exception exception, Map<String, String> properties, Map<String, String> tags, Map<String, Double> metrics, String instrumentationKey) {
        if (delegate != null) {
            delegate.trackException(timestamp, exception, properties, tags, metrics, instrumentationKey);
        }
    }

    public static void flush() {
        if (delegate != null) {
            delegate.flush();
        }
    }

    public static void logErrorOnce(Throwable t) {
        if (delegate != null) {
            delegate.logErrorOnce(t);
        }
    }

    public static long getTotalMilliseconds(long days, int hours, int minutes, int seconds, int milliseconds) {
        return TimeUnit.DAYS.toMillis(days) + TimeUnit.HOURS.toMillis(hours) + TimeUnit.MINUTES.toMillis(minutes) + TimeUnit.SECONDS.toMillis(seconds) + (long)milliseconds;
    }

    public static void copy(Map<String, String> source, Map<String, String> target, String excludePrefix) {
        if (source == null) {
            return;
        }
        for (Map.Entry<String, String> entry : source.entrySet()) {
            String value;
            String key = entry.getKey();
            if (key == null || key.isEmpty() || excludePrefix != null && key.startsWith(excludePrefix) || target.containsKey(key) || (value = entry.getValue()) == null) continue;
            target.put(key, value);
        }
    }

    public static void onEnter() {
        startNanosHolder.set(System.nanoTime());
    }

    public static void onExit() {
        Long startNanos = startNanosHolder.get();
        if (startNanos == null) {
            System.out.println("Signed jar access (no timing available)");
            Thread.dumpStack();
        } else {
            long durationNanos = System.nanoTime() - startNanos;
            if (durationNanos > TimeUnit.MILLISECONDS.toNanos(1L)) {
                System.out.println("Signed jar access (" + TimeUnit.NANOSECONDS.toMillis(durationNanos) + " milliseconds)");
                Thread.dumpStack();
            }
        }
        startNanosHolder.remove();
    }

    private BytecodeUtil() {
    }

    static {
        startNanosHolder = new ThreadLocal();
    }

    public static interface BytecodeUtilDelegate {
        public void trackEvent(Date var1, String var2, Map<String, String> var3, Map<String, String> var4, Map<String, Double> var5, String var6);

        public void trackMetric(Date var1, String var2, double var3, Integer var5, Double var6, Double var7, Double var8, Map<String, String> var9, Map<String, String> var10, String var11);

        public void trackDependency(Date var1, String var2, String var3, String var4, Long var5, boolean var6, String var7, String var8, String var9, Map<String, String> var10, Map<String, String> var11, Map<String, Double> var12, String var13);

        public void trackPageView(Date var1, String var2, URI var3, long var4, Map<String, String> var6, Map<String, String> var7, Map<String, Double> var8, String var9);

        public void trackTrace(Date var1, String var2, int var3, Map<String, String> var4, Map<String, String> var5, String var6);

        public void trackRequest(String var1, String var2, URL var3, Date var4, Long var5, String var6, boolean var7, String var8, Map<String, String> var9, Map<String, String> var10, Map<String, Double> var11, String var12);

        public void trackException(Date var1, Exception var2, Map<String, String> var3, Map<String, String> var4, Map<String, Double> var5, String var6);

        public void flush();

        public void logErrorOnce(Throwable var1);
    }
}

