/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.core;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.core.Base64;
import com.microsoft.azure.storage.core.Canonicalizer;
import com.microsoft.azure.storage.core.CanonicalizerFactory;
import com.microsoft.azure.storage.core.Logger;
import com.microsoft.azure.storage.core.Utility;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.security.InvalidKeyException;

public final class StorageCredentialsHelper {
    public static boolean canCredentialsSignRequest(StorageCredentials creds) {
        return creds.getClass().equals(StorageCredentialsAccountAndKey.class);
    }

    public static boolean canCredentialsGenerateClient(StorageCredentials creds) {
        return StorageCredentialsHelper.canCredentialsSignRequest(creds) || creds.getClass().equals(StorageCredentialsSharedAccessSignature.class);
    }

    public static synchronized String computeHmac256(StorageCredentials creds, String value) throws InvalidKeyException {
        if (creds.getClass().equals(StorageCredentialsAccountAndKey.class)) {
            byte[] utf8Bytes = null;
            try {
                utf8Bytes = value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
            return Base64.encode(((StorageCredentialsAccountAndKey)creds).getHmac256().doFinal(utf8Bytes));
        }
        return null;
    }

    public static void signBlobQueueAndFileRequest(StorageCredentials creds, HttpURLConnection request, long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        if (creds.getClass().equals(StorageCredentialsAccountAndKey.class)) {
            opContext = opContext == null ? new OperationContext() : opContext;
            request.setRequestProperty("x-ms-date", Utility.getGMTTime());
            Canonicalizer canonicalizer = CanonicalizerFactory.getBlobQueueFileCanonicalizer(request);
            String stringToSign = canonicalizer.canonicalize(request, creds.getAccountName(), contentLength);
            String computedBase64Signature = StorageCredentialsHelper.computeHmac256(creds, stringToSign);
            Logger.debug(opContext, "Signing %s", (Object)stringToSign);
            request.setRequestProperty("Authorization", String.format("%s %s:%s", "SharedKey", creds.getAccountName(), computedBase64Signature));
        }
    }

    public static void signTableRequest(StorageCredentials creds, HttpURLConnection request, long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        if (creds.getClass().equals(StorageCredentialsAccountAndKey.class)) {
            opContext = opContext == null ? new OperationContext() : opContext;
            request.setRequestProperty("x-ms-date", Utility.getGMTTime());
            Canonicalizer canonicalizer = CanonicalizerFactory.getTableCanonicalizer(request);
            String stringToSign = canonicalizer.canonicalize(request, creds.getAccountName(), contentLength);
            String computedBase64Signature = StorageCredentialsHelper.computeHmac256(creds, stringToSign);
            Logger.debug(opContext, "Signing %s", (Object)stringToSign);
            request.setRequestProperty("Authorization", String.format("%s %s:%s", "SharedKey", creds.getAccountName(), computedBase64Signature));
        }
    }

    private StorageCredentialsHelper() {
    }
}

