/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.blob.BlockEntry;
import com.microsoft.azure.storage.blob.BlockSearchMode;
import com.microsoft.azure.storage.core.Utility;
import java.io.IOException;
import java.io.StringWriter;
import org.xmlpull.v1.XmlSerializer;

final class BlockEntryListSerializer {
    BlockEntryListSerializer() {
    }

    public static byte[] writeBlockListToStream(Iterable<BlockEntry> blockList, OperationContext opContext) throws IllegalArgumentException, IllegalStateException, IOException {
        StringWriter outWriter = new StringWriter();
        XmlSerializer xmlw = Utility.getXmlSerializer(outWriter);
        xmlw.startDocument("UTF-8", Boolean.valueOf(true));
        xmlw.startTag("", "BlockList");
        for (BlockEntry block : blockList) {
            if (block.getSearchMode() == BlockSearchMode.COMMITTED) {
                Utility.serializeElement(xmlw, "Committed", block.getId());
                continue;
            }
            if (block.getSearchMode() == BlockSearchMode.UNCOMMITTED) {
                Utility.serializeElement(xmlw, "Uncommitted", block.getId());
                continue;
            }
            if (block.getSearchMode() != BlockSearchMode.LATEST) continue;
            Utility.serializeElement(xmlw, "Latest", block.getId());
        }
        xmlw.endTag("", "BlockList");
        xmlw.endDocument();
        return outWriter.toString().getBytes("UTF-8");
    }
}

