/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.SharedAccessPolicy;
import com.microsoft.azure.storage.core.Utility;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlSerializer;

public final class SharedAccessPolicySerializer {
    public static <T extends SharedAccessPolicy> void writeSharedAccessIdentifiersToStream(HashMap<String, T> sharedAccessPolicies, StringWriter outWriter) throws IllegalArgumentException, IllegalStateException, IOException {
        Utility.assertNotNull("sharedAccessPolicies", sharedAccessPolicies);
        Utility.assertNotNull("outWriter", outWriter);
        XmlSerializer xmlw = Utility.getXmlSerializer(outWriter);
        if (sharedAccessPolicies.keySet().size() > 5) {
            String errorMessage = String.format("Too many %d shared access policy identifiers provided. Server does not support setting more than %d on a single container, queue, or table.", sharedAccessPolicies.keySet().size(), 5);
            throw new IllegalArgumentException(errorMessage);
        }
        xmlw.startDocument("UTF-8", Boolean.valueOf(true));
        xmlw.startTag("", "SignedIdentifiers");
        for (Map.Entry<String, T> entry : sharedAccessPolicies.entrySet()) {
            SharedAccessPolicy policy = (SharedAccessPolicy)entry.getValue();
            xmlw.startTag("", "SignedIdentifier");
            Utility.serializeElement(xmlw, "Id", entry.getKey());
            xmlw.startTag("", "AccessPolicy");
            Utility.serializeElement(xmlw, "Start", Utility.getUTCTimeOrEmpty(policy.getSharedAccessStartTime()).toString());
            Utility.serializeElement(xmlw, "Expiry", Utility.getUTCTimeOrEmpty(policy.getSharedAccessExpiryTime()).toString());
            Utility.serializeElement(xmlw, "Permission", policy.permissionsToString());
            xmlw.endTag("", "AccessPolicy");
            xmlw.endTag("", "SignedIdentifier");
        }
        xmlw.endTag("", "SignedIdentifiers");
        xmlw.endDocument();
    }
}

