/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.AdalJWTClaimsSet;
import com.microsoft.aad.adal4j.AsymmetricKeyCredential;
import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.aad.adal4j.ClientAssertion;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Date;

final class JwtHelper {
    JwtHelper() {
    }

    static ClientAssertion buildJwt(AsymmetricKeyCredential credential, String jwtAudience) throws AuthenticationException {
        if (credential == null) {
            throw new IllegalArgumentException("credential is null");
        }
        AdalJWTClaimsSet claimsSet = new AdalJWTClaimsSet();
        ArrayList<String> audience = new ArrayList<String>();
        audience.add(jwtAudience);
        claimsSet.setAudience(audience);
        claimsSet.setIssuer(credential.getClientId());
        long time = System.currentTimeMillis();
        claimsSet.setNotBeforeTime(new Date(time));
        claimsSet.setExpirationTime(new Date(time + 600000L));
        claimsSet.setSubject(credential.getClientId());
        SignedJWT jwt = null;
        try {
            JWSHeader.Builder builder = new JWSHeader.Builder(JWSAlgorithm.RS256);
            ArrayList<Base64> certs = new ArrayList<Base64>();
            certs.add(new Base64(credential.getPublicCertificate()));
            builder.x509CertChain(certs);
            builder.x509CertThumbprint(new Base64URL(credential.getPublicCertificateHash()));
            jwt = new SignedJWT(builder.build(), (ReadOnlyJWTClaimsSet)claimsSet);
            RSASSASigner signer = new RSASSASigner((RSAPrivateKey)credential.getKey());
            jwt.sign((JWSSigner)signer);
        }
        catch (Exception e) {
            throw new AuthenticationException(e);
        }
        return new ClientAssertion(jwt.serialize());
    }
}

