/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.HttpHelper;
import com.microsoft.aad.adal4j.StringHelper;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AdalOAuthRequest
extends HTTPRequest {
    private final Map<String, String> extraHeaderParams;
    private final Logger log = LoggerFactory.getLogger(AdalOAuthRequest.class);

    AdalOAuthRequest(HTTPRequest.Method method, URL url, Map<String, String> extraHeaderParams) {
        super(method, url);
        this.extraHeaderParams = extraHeaderParams;
    }

    Map<String, String> getReadOnlyExtraHeaderParameters() {
        return Collections.unmodifiableMap(this.extraHeaderParams);
    }

    public HTTPResponse send() throws IOException {
        HttpURLConnection conn = HttpHelper.openConnection(this.getURL());
        this.configureHeaderAndExecuteOAuthCall(conn);
        String out = this.processAndReadResponse(conn);
        HttpHelper.verifyReturnedCorrelationId(this.log, conn, this.extraHeaderParams.get("client-request-id"));
        return this.createResponse(conn, out);
    }

    HTTPResponse createResponse(HttpURLConnection conn, String out) throws IOException {
        HTTPResponse response = new HTTPResponse(conn.getResponseCode());
        String location = conn.getHeaderField("Location");
        if (!StringHelper.isBlank(location)) {
            response.setLocation(new URL(location));
        }
        try {
            response.setContentType(conn.getContentType());
        }
        catch (ParseException e) {
            throw new IOException("Couldn't parse Content-Type header: " + e.getMessage(), e);
        }
        response.setCacheControl(conn.getHeaderField("Cache-Control"));
        response.setPragma(conn.getHeaderField("Pragma"));
        response.setWWWAuthenticate(conn.getHeaderField("WWW-Authenticate"));
        if (!StringHelper.isBlank(out)) {
            response.setContent(out);
        }
        return response;
    }

    void configureHeaderAndExecuteOAuthCall(HttpURLConnection conn) throws IOException {
        if (this.getAuthorization() != null) {
            conn.setRequestProperty("Authorization", this.getAuthorization());
        }
        HttpHelper.configureAdditionalHeaders(conn, this.extraHeaderParams);
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", CommonContentTypes.APPLICATION_URLENCODED.toString());
        if (this.getQuery() != null) {
            OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
            writer.write(this.getQuery());
            writer.flush();
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String processAndReadResponse(HttpURLConnection conn) throws IOException {
        InputStreamReader inReader = null;
        int responseCode = conn.getResponseCode();
        inReader = responseCode == 200 ? new InputStreamReader(conn.getInputStream()) : new InputStreamReader(conn.getErrorStream());
        BufferedReader reader = new BufferedReader(inReader);
        char[] buffer = new char[256];
        StringBuilder out = new StringBuilder();
        try {
            int rsz;
            while ((rsz = reader.read(buffer, 0, buffer.length)) >= 0) {
                out.append(buffer, 0, rsz);
            }
        }
        finally {
            reader.close();
        }
        return out.toString();
    }
}

