/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.AdalAccessTokenResponse;
import com.microsoft.aad.adal4j.AdalAuthorizatonGrant;
import com.microsoft.aad.adal4j.AdalOAuthRequest;
import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.StringHelper;
import com.microsoft.aad.adal4j.UserInfo;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Map;

class AdalTokenRequest {
    private final URL uri;
    private final ClientAuthentication clientAuth;
    private final AdalAuthorizatonGrant authzGrant;
    private final Map<String, String> headerMap;

    AdalTokenRequest(URL uri, ClientAuthentication clientAuth, AdalAuthorizatonGrant authzGrant, Map<String, String> headerMap) {
        this.clientAuth = clientAuth;
        this.authzGrant = authzGrant;
        this.uri = uri;
        this.headerMap = headerMap;
    }

    AuthenticationResult executeOAuthRequestAndProcessResponse() throws ParseException, AuthenticationException, SerializeException, IOException, java.text.ParseException {
        UserInfo info;
        String refreshToken;
        AdalAccessTokenResponse response;
        AuthenticationResult result = null;
        HTTPResponse httpResponse = null;
        AdalOAuthRequest adalOAuthHttpRequest = this.toOAuthRequest();
        httpResponse = adalOAuthHttpRequest.send();
        if (httpResponse.getStatusCode() == 200) {
            response = AdalAccessTokenResponse.parseHttpResponse(httpResponse);
            refreshToken = null;
            if (response.getRefreshToken() != null) {
                refreshToken = response.getRefreshToken().getValue();
            }
            info = null;
            if (response.getIDToken() != null) {
                info = UserInfo.createFromIdTokenClaims(response.getIDToken().getJWTClaimsSet());
            }
        } else {
            TokenErrorResponse errorResponse = TokenErrorResponse.parse((HTTPResponse)httpResponse);
            throw new AuthenticationException(errorResponse.toJSONObject().toJSONString());
        }
        result = new AuthenticationResult(response.getAccessToken().getType().getValue(), response.getAccessToken().getValue(), refreshToken, response.getAccessToken().getLifetime(), info, !StringHelper.isBlank(response.getResource()));
        return result;
    }

    AdalOAuthRequest toOAuthRequest() throws SerializeException {
        if (this.uri == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        AdalOAuthRequest httpRequest = new AdalOAuthRequest(HTTPRequest.Method.POST, this.uri, this.headerMap);
        httpRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
        Map<String, String> params = this.authzGrant.toParameters();
        httpRequest.setQuery(URLUtils.serializeParameters(params));
        if (this.clientAuth != null) {
            this.clientAuth.applyTo((HTTPRequest)httpRequest);
        }
        return httpRequest;
    }
}

