/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.reactnative.shared;

import android.app.Application;
import com.microsoft.appcenter.AppCenter;
import com.microsoft.appcenter.ingestion.models.WrapperSdk;
import java.io.InputStream;
import org.json.JSONObject;

public class AppCenterReactNativeShared {
    private static String appSecret;
    private static Application application;
    private static WrapperSdk wrapperSdk;

    public static void configureAppCenter(Application application) {
        if (AppCenter.isConfigured()) {
            return;
        }
        AppCenterReactNativeShared.application = application;
        wrapperSdk.setWrapperSdkVersion("1.0.1");
        wrapperSdk.setWrapperSdkName("appcenter.react-native");
        AppCenter.setWrapperSdk((WrapperSdk)wrapperSdk);
        AppCenter.configure((Application)application, (String)AppCenterReactNativeShared.getAppSecret());
    }

    public static void setWrapperSdk(WrapperSdk wrapperSdk) {
        AppCenterReactNativeShared.wrapperSdk = wrapperSdk;
        AppCenter.setWrapperSdk((WrapperSdk)wrapperSdk);
    }

    public static WrapperSdk getWrapperSdk() {
        return wrapperSdk;
    }

    public static void setAppSecret(String secret) {
        appSecret = secret;
    }

    public static String getAppSecret() {
        if (appSecret == null) {
            try {
                InputStream configStream = application.getAssets().open("appcenter-config.json");
                int size = configStream.available();
                byte[] buffer = new byte[size];
                configStream.read(buffer);
                configStream.close();
                String jsonContents = new String(buffer, "UTF-8");
                JSONObject json = new JSONObject(jsonContents);
                appSecret = json.getString("app_secret");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return appSecret;
    }

    static {
        wrapperSdk = new WrapperSdk();
    }
}

