/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.push;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.microsoft.appcenter.utils.AppCenterLog;

class FirebaseUtils {
    @VisibleForTesting
    FirebaseUtils() {
    }

    static boolean isFirebaseAvailable() {
        try {
            FirebaseUtils.getFirebaseInstanceId();
            return true;
        }
        catch (FirebaseUnavailableException e) {
            return false;
        }
    }

    static void setAnalyticsEnabled(@NonNull Context context, boolean enabled) {
        try {
            FirebaseAnalytics.getInstance((Context)context).setAnalyticsCollectionEnabled(enabled);
        }
        catch (LinkageError e) {
            AppCenterLog.debug((String)"AppCenterPush", (String)"Firebase analytics not available so cannot change state.");
        }
    }

    static void setFirebaseMessagingServiceEnabled(@NonNull Context context, boolean enabled) {
        PackageManager packageManager = context.getPackageManager();
        ComponentName firebaseComponentName = new ComponentName(context, FirebaseMessagingService.class.getName());
        packageManager.setComponentEnabledSetting(firebaseComponentName, enabled ? 0 : 2, 1);
    }

    @NonNull
    static FirebaseInstanceId getFirebaseInstanceId() throws FirebaseUnavailableException {
        try {
            FirebaseInstanceId instance = FirebaseInstanceId.getInstance();
            if (instance == null) {
                throw new FirebaseUnavailableException("null instance");
            }
            return instance;
        }
        catch (IllegalStateException e) {
            throw new FirebaseUnavailableException(e);
        }
    }

    static class FirebaseUnavailableException
    extends Exception {
        FirebaseUnavailableException(Throwable cause) {
            super(cause);
        }

        FirebaseUnavailableException(String message) {
            super(message);
        }
    }
}

