/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.push;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.microsoft.appcenter.push.PushIntentUtils;
import com.microsoft.appcenter.push.R;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.AppNameHelper;
import com.microsoft.appcenter.utils.UUIDUtils;
import java.util.Map;

class PushNotifier {
    private static final String CHANNEL_ID = "app_center_push";
    private static final String CHANNEL_NAME = "Push";
    @VisibleForTesting
    static final String DEFAULT_ICON_METADATA_NAME = "com.google.firebase.messaging.default_notification_icon";
    @VisibleForTesting
    static final String DEFAULT_COLOR_METADATA_NAME = "com.google.firebase.messaging.default_notification_color";

    PushNotifier() {
    }

    static void handleNotification(Context context, Intent pushIntent) throws RuntimeException {
        Notification.Builder builder;
        context = context.getApplicationContext();
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        String messageId = PushIntentUtils.getMessageId(pushIntent);
        if (messageId == null) {
            AppCenterLog.warn((String)"AppCenterPush", (String)"Push notification did not contain identifier, generate one.");
            messageId = UUIDUtils.randomUUID().toString();
        }
        int notificationId = messageId.hashCode();
        PackageManager packageManager = context.getPackageManager();
        Intent actionIntent = packageManager.getLaunchIntentForPackage(context.getPackageName());
        if (actionIntent != null) {
            actionIntent.setFlags(0x14000000);
            Map<String, String> customData = PushIntentUtils.getCustomData(pushIntent);
            for (String key : customData.keySet()) {
                actionIntent.putExtra(key, customData.get(key));
            }
            PushIntentUtils.setMessageId(messageId, actionIntent);
        } else {
            actionIntent = new Intent();
        }
        String notificationTitle = PushIntentUtils.getTitle(pushIntent);
        if (notificationTitle == null || notificationTitle.isEmpty()) {
            notificationTitle = AppNameHelper.getAppName((Context)context);
        }
        String notificationMessage = PushIntentUtils.getMessage(pushIntent);
        if (Build.VERSION.SDK_INT >= 26 && context.getApplicationInfo().targetSdkVersion >= 26) {
            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, (CharSequence)CHANNEL_NAME, 3);
            notificationManager.createNotificationChannel(channel);
            builder = new Notification.Builder(context, channel.getId());
        } else {
            builder = PushNotifier.getOldNotificationBuilder(context);
        }
        PushNotifier.setColor(context, pushIntent, builder);
        PushNotifier.setIcon(context, pushIntent, builder);
        PushNotifier.setSound(context, pushIntent, builder);
        builder.setContentTitle((CharSequence)notificationTitle).setContentText((CharSequence)notificationMessage).setWhen(System.currentTimeMillis()).setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)notificationMessage));
        PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)notificationId, (Intent)actionIntent, (int)0);
        builder.setContentIntent(contentIntent);
        Notification notification = builder.build();
        notification.flags |= 0x10;
        notificationManager.notify(notificationId, notification);
    }

    @NonNull
    private static Notification.Builder getOldNotificationBuilder(Context context) {
        return new Notification.Builder(context);
    }

    private static void setColor(Context context, Intent pushIntent, Notification.Builder builder) {
        int colorResourceId;
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        String colorString = PushIntentUtils.getColor(pushIntent);
        if (colorString != null) {
            try {
                builder.setColor(Color.parseColor((String)colorString));
                return;
            }
            catch (IllegalArgumentException e) {
                AppCenterLog.error((String)"AppCenterPush", (String)"Invalid color string received in push payload.", (Throwable)e);
            }
        }
        if ((colorResourceId = PushNotifier.getResourceIdFromMetadata(context, DEFAULT_COLOR_METADATA_NAME)) != 0) {
            AppCenterLog.debug((String)"AppCenterPush", (String)"Using color specified in meta-data for notification.");
            builder.setColor(PushNotifier.getColor(context, colorResourceId));
        }
    }

    private static void setSound(Context context, Intent pushIntent, Notification.Builder builder) {
        String sound = PushIntentUtils.getSound(pushIntent);
        if (sound != null) {
            try {
                Resources resources = context.getResources();
                int id = resources.getIdentifier(sound, "raw", context.getPackageName());
                Uri soundUri = new Uri.Builder().scheme("android.resource").authority(resources.getResourcePackageName(id)).appendPath(resources.getResourceTypeName(id)).appendPath(resources.getResourceEntryName(id)).build();
                builder.setSound(soundUri);
            }
            catch (Resources.NotFoundException e) {
                AppCenterLog.warn((String)"AppCenterPush", (String)("Sound file '" + sound + "' not found; falling back to default."));
                builder.setDefaults(1);
            }
        }
    }

    private static void setIcon(Context context, Intent pushIntent, Notification.Builder builder) {
        String iconString = PushIntentUtils.getIcon(pushIntent);
        int iconResourceId = 0;
        if (!TextUtils.isEmpty((CharSequence)iconString)) {
            String packageName;
            Resources resources = context.getResources();
            iconResourceId = resources.getIdentifier(iconString, "drawable", packageName = context.getPackageName());
            if (iconResourceId != 0) {
                AppCenterLog.debug((String)"AppCenterPush", (String)"Found icon resource in 'drawable'.");
            } else {
                iconResourceId = resources.getIdentifier(iconString, "mipmap", packageName);
                if (iconResourceId != 0) {
                    AppCenterLog.debug((String)"AppCenterPush", (String)"Found icon resource in 'mipmap'.");
                }
            }
        }
        if (iconResourceId != 0) {
            iconResourceId = PushNotifier.validateIcon(context, iconResourceId);
        }
        if (iconResourceId == 0 && (iconResourceId = PushNotifier.getResourceIdFromMetadata(context, DEFAULT_ICON_METADATA_NAME)) != 0) {
            AppCenterLog.debug((String)"AppCenterPush", (String)"Using icon specified in meta-data for notification.");
            iconResourceId = PushNotifier.validateIcon(context, iconResourceId);
        }
        if (iconResourceId == 0) {
            AppCenterLog.debug((String)"AppCenterPush", (String)"Using application icon as notification icon.");
            iconResourceId = PushNotifier.validateIcon(context, context.getApplicationInfo().icon);
        }
        if (iconResourceId == 0) {
            AppCenterLog.warn((String)"AppCenterPush", (String)"Using 1 pixel icon as fallback for notification.");
            iconResourceId = R.drawable.ic_stat_notify_dot;
        }
        builder.setSmallIcon(iconResourceId);
    }

    private static int validateIcon(Context context, int iconResourceId) {
        if (iconResourceId == 0) {
            return iconResourceId;
        }
        if (Build.VERSION.SDK_INT == 26 && context.getDrawable(iconResourceId) instanceof AdaptiveIconDrawable) {
            AppCenterLog.error((String)"AppCenterPush", (String)"Adaptive icons make Notification center crash (system process) on Android 8.0 (was fixed on Android 8.1), please update your icon to be non adaptive or please use another icon to push.");
            iconResourceId = 0;
        }
        return iconResourceId;
    }

    private static int getResourceIdFromMetadata(Context context, String metadataName) {
        Bundle metaData = null;
        try {
            metaData = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            AppCenterLog.error((String)"AppCenterPush", (String)"Package name not found.", (Throwable)e);
        }
        if (metaData != null) {
            return metaData.getInt(metadataName);
        }
        return 0;
    }

    private static int getColor(Context context, int colorResourceId) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context.getColor(colorResourceId);
        }
        return context.getResources().getColor(colorResourceId);
    }
}

