/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.push;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.VisibleForTesting;
import com.microsoft.appcenter.AbstractAppCenterService;
import com.microsoft.appcenter.channel.Channel;
import com.microsoft.appcenter.ingestion.models.Log;
import com.microsoft.appcenter.ingestion.models.json.LogFactory;
import com.microsoft.appcenter.push.FirebaseUtils;
import com.microsoft.appcenter.push.PushIntentUtils;
import com.microsoft.appcenter.push.PushListener;
import com.microsoft.appcenter.push.PushNotification;
import com.microsoft.appcenter.push.PushNotifier;
import com.microsoft.appcenter.push.ingestion.models.PushInstallationLog;
import com.microsoft.appcenter.push.ingestion.models.json.PushInstallationLogFactory;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.async.AppCenterFuture;
import java.util.HashMap;
import java.util.Map;

public class Push
extends AbstractAppCenterService {
    private static final String SERVICE_NAME = "Push";
    static final String LOG_TAG = "AppCenterPush";
    private static final String PUSH_GROUP = "group_push";
    @SuppressLint(value={"StaticFieldLeak"})
    private static Push sInstance;
    private final Map<String, LogFactory> mFactories = new HashMap<String, LogFactory>();
    private PushListener mInstanceListener;
    private boolean mFirebaseAnalyticsEnabled;
    private String mLastGoogleMessageId;
    private String mFirstGoogleMessageId;
    private Activity mActivity;
    private Context mContext;
    private String mSenderId;
    private boolean mTokenNeedsRegistrationInForeground;

    private Push() {
        this.mFactories.put("pushInstallation", (LogFactory)new PushInstallationLogFactory());
    }

    public static synchronized Push getInstance() {
        if (sInstance == null) {
            sInstance = new Push();
        }
        return sInstance;
    }

    @VisibleForTesting
    static synchronized void unsetInstance() {
        sInstance = null;
    }

    public static AppCenterFuture<Boolean> isEnabled() {
        return Push.getInstance().isInstanceEnabledAsync();
    }

    public static AppCenterFuture<Void> setEnabled(boolean enabled) {
        return Push.getInstance().setInstanceEnabledAsync(enabled);
    }

    public static void setListener(PushListener pushListener) {
        Push.getInstance().setInstanceListener(pushListener);
    }

    public static void checkLaunchedFromNotification(Activity activity, Intent intent) {
        Push.getInstance().checkPushInActivityIntent(activity, intent);
    }

    @Deprecated
    public static void setSenderId(String senderId) {
        Push.getInstance().instanceSetSenderId(senderId);
    }

    public static void enableFirebaseAnalytics(@NonNull Context context) {
        AppCenterLog.debug((String)LOG_TAG, (String)"Enabling Firebase analytics collection.");
        Push.getInstance().setFirebaseAnalyticsEnabled(context, true);
    }

    private synchronized void instanceSetSenderId(String senderId) {
        this.mSenderId = senderId;
    }

    private synchronized void setFirebaseAnalyticsEnabled(@NonNull Context context, boolean enabled) {
        FirebaseUtils.setAnalyticsEnabled(context, enabled);
        this.mFirebaseAnalyticsEnabled = enabled;
    }

    private void enqueuePushInstallationLog(@NonNull String pushToken) {
        PushInstallationLog log = new PushInstallationLog();
        log.setPushToken(pushToken);
        this.mChannel.enqueue((Log)log, PUSH_GROUP);
    }

    synchronized void onTokenRefresh(final String pushToken) {
        if (pushToken != null) {
            AppCenterLog.debug((String)LOG_TAG, (String)("Push token refreshed: " + pushToken));
            this.post(new Runnable(){

                @Override
                public void run() {
                    Push.this.enqueuePushInstallationLog(pushToken);
                }
            });
        }
    }

    protected synchronized void applyEnabledState(boolean enabled) {
        if (enabled) {
            this.registerPushToken();
        }
    }

    protected String getGroupName() {
        return PUSH_GROUP;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    protected String getLoggerTag() {
        return LOG_TAG;
    }

    protected int getTriggerCount() {
        return 1;
    }

    public Map<String, LogFactory> getLogFactories() {
        return this.mFactories;
    }

    public synchronized void onStarted(@NonNull Context context, @NonNull Channel channel, String appSecret, String transmissionTargetToken, boolean startedFromApp) {
        this.mContext = context;
        super.onStarted(context, channel, appSecret, transmissionTargetToken, startedFromApp);
        if (FirebaseUtils.isFirebaseAvailable() && !this.mFirebaseAnalyticsEnabled) {
            AppCenterLog.debug((String)LOG_TAG, (String)"Disabling Firebase analytics collection by default.");
            this.setFirebaseAnalyticsEnabled(context, false);
        }
    }

    private synchronized void setInstanceListener(PushListener instanceListener) {
        this.mInstanceListener = instanceListener;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.checkPushInActivityIntent(activity);
    }

    public void onActivityStarted(Activity activity) {
        this.checkPushInActivityIntent(activity);
    }

    public synchronized void onActivityResumed(Activity activity) {
        this.checkPushInActivityIntent(activity);
        if (this.mTokenNeedsRegistrationInForeground) {
            this.mTokenNeedsRegistrationInForeground = false;
            this.registerPushToken();
        }
    }

    public void onActivityPaused(Activity activity) {
        this.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                Push.this.mActivity = null;
            }
        });
    }

    private void checkPushInActivityIntent(Activity activity) {
        this.checkPushInActivityIntent(activity, activity.getIntent());
    }

    private void checkPushInActivityIntent(final Activity activity, final Intent intent) {
        if (activity == null) {
            AppCenterLog.error((String)LOG_TAG, (String)"Push.checkLaunchedFromNotification: activity may not be null");
            return;
        }
        if (intent == null) {
            AppCenterLog.error((String)LOG_TAG, (String)"Push.checkLaunchedFromNotification: intent may not be null");
            return;
        }
        this.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                Push.this.mActivity = activity;
                Push.this.checkPushInIntent(intent);
            }
        });
    }

    private synchronized void checkPushInIntent(Intent intent) {
        String googleMessageId;
        if (this.mInstanceListener != null && (googleMessageId = PushIntentUtils.getMessageId(intent)) != null && !googleMessageId.equals(this.mLastGoogleMessageId) && !googleMessageId.equals(this.mFirstGoogleMessageId)) {
            if (this.mFirstGoogleMessageId == null) {
                this.mFirstGoogleMessageId = googleMessageId;
            }
            PushNotification notification = new PushNotification(intent);
            AppCenterLog.info((String)LOG_TAG, (String)("Clicked push message from background id=" + googleMessageId));
            this.mLastGoogleMessageId = googleMessageId;
            AppCenterLog.debug((String)LOG_TAG, (String)("Push intent extras=" + intent.getExtras()));
            this.mInstanceListener.onPushNotificationReceived(this.mActivity, notification);
        }
    }

    synchronized void onMessageReceived(Context context, Intent pushIntent) {
        boolean isBackground;
        boolean bl = isBackground = this.mActivity == null;
        if (AppCenterLog.getLogLevel() <= 3) {
            StringBuilder message = new StringBuilder("Received push intent=");
            message.append(pushIntent);
            message.append(" background=").append(isBackground);
            Bundle intentExtras = pushIntent.getExtras();
            if (intentExtras != null) {
                message.append('\n');
                for (String key : intentExtras.keySet()) {
                    message.append(key).append("=").append(intentExtras.get(key)).append('\n');
                }
            }
            AppCenterLog.debug((String)LOG_TAG, (String)message.toString());
        }
        if (isBackground) {
            if (FirebaseUtils.isFirebaseAvailable()) {
                AppCenterLog.debug((String)LOG_TAG, (String)"Background notifications are handled by Firebase SDK when integrated.");
            } else {
                PushNotifier.handleNotification(context, pushIntent);
            }
        } else {
            final PushNotification notification = new PushNotification(pushIntent);
            this.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Push.this.handleOnMessageReceived(notification);
                }
            });
        }
    }

    private synchronized void registerPushToken() {
        FirebaseUtils.setFirebaseMessagingServiceEnabled(this.mContext, FirebaseUtils.isFirebaseAvailable());
        try {
            this.onTokenRefresh(FirebaseUtils.getToken());
            AppCenterLog.info((String)LOG_TAG, (String)"Firebase SDK is available, using Firebase SDK registration.");
        }
        catch (FirebaseUtils.FirebaseUnavailableException e) {
            AppCenterLog.warn((String)LOG_TAG, (String)("Firebase SDK is not available, using built in registration. For all the Android developers using App Center, there is a change coming where Firebase SDK is required to use Push Notifications. For Android P, its scheduled at the release date for the latest OS version. For all other versions of Android, it will be required after April 2019. Please follow the migration guide at https://aka.ms/acfba.\nCause: " + e.getMessage()));
            this.registerPushTokenWithoutFirebase();
        }
    }

    private synchronized void registerPushTokenWithoutFirebase() {
        if (this.mSenderId == null) {
            int resId = this.mContext.getResources().getIdentifier("gcm_defaultSenderId", "string", this.mContext.getPackageName());
            try {
                this.mSenderId = this.mContext.getString(resId);
            }
            catch (Resources.NotFoundException e) {
                AppCenterLog.error((String)LOG_TAG, (String)"Push.setSenderId was not called, aborting registration.");
                return;
            }
        }
        Intent registrationIntent = new Intent("com.google.android.c2dm.intent.REGISTER");
        registrationIntent.setPackage("com.google.android.gsf");
        registrationIntent.putExtra("sender", this.mSenderId);
        registrationIntent.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(), (int)0));
        try {
            this.mContext.startService(registrationIntent);
        }
        catch (IllegalStateException e) {
            AppCenterLog.info((String)LOG_TAG, (String)"Cannot register in background, will wait to be in foreground");
            this.mTokenNeedsRegistrationInForeground = true;
        }
        catch (RuntimeException e) {
            AppCenterLog.error((String)LOG_TAG, (String)"Failed to register push token", (Throwable)e);
        }
    }

    @UiThread
    private synchronized void handleOnMessageReceived(PushNotification pushNotification) {
        if (this.mInstanceListener != null) {
            this.mInstanceListener.onPushNotificationReceived(this.mActivity, pushNotification);
        }
    }
}

