/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.push;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.google.firebase.iid.FirebaseInstanceId;

class FirebaseUtils {
    @VisibleForTesting
    FirebaseUtils() {
    }

    static boolean isFirebaseAvailable() {
        try {
            FirebaseUtils.getFirebaseInstanceId();
            return true;
        }
        catch (FirebaseUnavailableException e) {
            return false;
        }
    }

    static void setAnalyticsEnabled(@NonNull Context context, boolean enabled) throws FirebaseUnavailableException {
        try {
            FirebaseAnalytics instance = FirebaseAnalytics.getInstance((Context)context);
            if (instance == null) {
                throw new FirebaseUnavailableException("null instance");
            }
            instance.setAnalyticsCollectionEnabled(enabled);
        }
        catch (IllegalAccessError | NoClassDefFoundError e) {
            throw new FirebaseUnavailableException(e);
        }
    }

    @Nullable
    static String getToken() throws FirebaseUnavailableException {
        return FirebaseUtils.getFirebaseInstanceId().getToken();
    }

    @NonNull
    private static FirebaseInstanceId getFirebaseInstanceId() throws FirebaseUnavailableException {
        try {
            FirebaseInstanceId instance = FirebaseInstanceId.getInstance();
            if (instance == null) {
                throw new FirebaseUnavailableException("null instance");
            }
            return instance;
        }
        catch (IllegalAccessError | IllegalStateException | NoClassDefFoundError e) {
            throw new FirebaseUnavailableException(e);
        }
    }

    static class FirebaseUnavailableException
    extends Exception {
        FirebaseUnavailableException(Throwable cause) {
            super(cause);
        }

        FirebaseUnavailableException(String message) {
            super(message);
        }
    }
}

