/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.push;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import com.microsoft.appcenter.push.Push;
import com.microsoft.appcenter.push.PushIntentUtils;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.AppNameHelper;
import java.util.Map;

class PushNotifier {
    private static final String CHANNEL_ID = "app_center_push";
    private static final String CHANNEL_NAME = "Push";

    PushNotifier() {
    }

    static void handleNotification(Context context, Intent pushIntent) throws RuntimeException {
        context = context.getApplicationContext();
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        String messageId = PushIntentUtils.getGoogleMessageId(pushIntent);
        if (messageId == null) {
            AppCenterLog.error((String)Push.getInstance().getLoggerTag(), (String)"Push notification did notcontain Google message ID; aborting notification processing.");
            return;
        }
        int notificationId = messageId.hashCode();
        PackageManager packageManager = context.getPackageManager();
        Intent actionIntent = packageManager.getLaunchIntentForPackage(context.getPackageName());
        if (actionIntent != null) {
            actionIntent.setFlags(0x14000000);
            Map<String, String> customData = PushIntentUtils.getCustomData(pushIntent);
            for (String key : customData.keySet()) {
                actionIntent.putExtra(key, customData.get(key));
            }
            PushIntentUtils.setGoogleMessageId(messageId, actionIntent);
        } else {
            actionIntent = new Intent();
        }
        String notificationTitle = PushIntentUtils.getTitle(pushIntent);
        if (notificationTitle == null || notificationTitle.isEmpty()) {
            notificationTitle = AppNameHelper.getAppName((Context)context);
        }
        String notificationMessage = PushIntentUtils.getMessage(pushIntent);
        Notification.Builder builder = new Notification.Builder(context);
        PushNotifier.setColor(pushIntent, builder);
        PushNotifier.setIcon(context, pushIntent, builder);
        PushNotifier.setSound(context, pushIntent, builder);
        builder.setContentTitle((CharSequence)notificationTitle).setContentText((CharSequence)notificationMessage).setWhen(System.currentTimeMillis());
        PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)notificationId, (Intent)actionIntent, (int)0);
        builder.setContentIntent(contentIntent);
        if (Build.VERSION.SDK_INT >= 26 && context.getApplicationInfo().targetSdkVersion >= 26) {
            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, (CharSequence)CHANNEL_NAME, 3);
            notificationManager.createNotificationChannel(channel);
            builder.setChannelId(channel.getId());
        }
        Notification notification = Build.VERSION.SDK_INT >= 16 ? builder.build() : builder.getNotification();
        notification.flags |= 0x10;
        notificationManager.notify(notificationId, notification);
    }

    private static void setColor(Intent pushIntent, Notification.Builder builder) {
        String colorString = PushIntentUtils.getColor(pushIntent);
        if (colorString != null && Build.VERSION.SDK_INT >= 21) {
            builder.setColor(Color.parseColor((String)colorString));
        }
    }

    private static void setSound(Context context, Intent pushIntent, Notification.Builder builder) {
        String sound = PushIntentUtils.getSound(pushIntent);
        if (sound != null) {
            try {
                Resources resources = context.getResources();
                int id = resources.getIdentifier(sound, "raw", context.getPackageName());
                Uri soundUri = new Uri.Builder().scheme("android.resource").authority(resources.getResourcePackageName(id)).appendPath(resources.getResourceTypeName(id)).appendPath(resources.getResourceEntryName(id)).build();
                builder.setSound(soundUri);
            }
            catch (Resources.NotFoundException e) {
                AppCenterLog.warn((String)Push.getInstance().getLoggerTag(), (String)("Sound file '" + sound + "' not found; falling back to default."));
                builder.setDefaults(1);
            }
        }
    }

    private static void setIcon(Context context, Intent pushIntent, Notification.Builder builder) {
        String iconString = PushIntentUtils.getIcon(pushIntent);
        if (iconString != null) {
            String packageName;
            Resources resources = context.getResources();
            int iconResourceId = resources.getIdentifier(iconString, "drawable", packageName = context.getPackageName());
            if (iconResourceId != 0) {
                AppCenterLog.debug((String)Push.getInstance().getLoggerTag(), (String)"Found icon resource in 'drawable'.");
                builder.setSmallIcon(iconResourceId);
                return;
            }
            iconResourceId = resources.getIdentifier(iconString, "mipmap", packageName);
            if (iconResourceId != 0) {
                AppCenterLog.debug((String)Push.getInstance().getLoggerTag(), (String)"Found icon resource in 'mipmap'.");
                builder.setSmallIcon(iconResourceId);
                return;
            }
        }
        AppCenterLog.debug((String)Push.getInstance().getLoggerTag(), (String)"Using application icon as notification icon.");
        builder.setSmallIcon(context.getApplicationInfo().icon);
    }
}

