/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.data;

import android.annotation.SuppressLint;
import android.content.Context;
import com.google.gson.JsonParseException;
import com.microsoft.appcenter.data.Utils;
import com.microsoft.appcenter.data.models.TokenResult;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.crypto.CryptoUtils;
import com.microsoft.appcenter.utils.storage.SharedPreferencesManager;
import java.util.HashSet;
import java.util.Set;

public class TokenManager {
    @SuppressLint(value={"StaticFieldLeak"})
    private static TokenManager sInstance;
    private final Context mContext;

    private TokenManager(Context context) {
        this.mContext = context;
    }

    public static TokenManager getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new TokenManager(context);
        }
        return sInstance;
    }

    private Set<String> getPartitionNames() {
        Set partitionNames = SharedPreferencesManager.getStringSet((String)"Data.partitions");
        return partitionNames == null ? new HashSet() : partitionNames;
    }

    TokenResult getCachedToken(String partitionName) {
        return this.getCachedToken(partitionName, false);
    }

    TokenResult getCachedToken(String partitionName, boolean includeExpiredToken) {
        String encryptedTokenResult = SharedPreferencesManager.getString((String)("Data.partition." + partitionName));
        String decryptedTokenResult = CryptoUtils.getInstance((Context)this.mContext).decrypt(encryptedTokenResult, false).getDecryptedData();
        TokenResult token = null;
        try {
            token = (TokenResult)Utils.getGson().fromJson(decryptedTokenResult, TokenResult.class);
        }
        catch (JsonParseException e) {
            AppCenterLog.warn((String)"AppCenterData", (String)String.format("Cached token cannot be parsed for partition '%s'", partitionName), (Throwable)e);
        }
        if (token != null) {
            if (!includeExpiredToken && System.currentTimeMillis() >= token.getExpirationDate().getTime()) {
                AppCenterLog.warn((String)"AppCenterData", (String)String.format("Cached token result is expired for partition '%s'", partitionName));
                return null;
            }
            AppCenterLog.debug((String)"AppCenterData", (String)String.format("Retrieved token from cache for partition '%s'", partitionName));
            if (!Utils.isValidTokenResult(token)) {
                AppCenterLog.warn((String)"AppCenterData", (String)"Getting an invalid token from local token cache.");
                return null;
            }
            return token;
        }
        AppCenterLog.debug((String)"AppCenterData", (String)String.format("No token found in cache for partition '%s'", partitionName));
        return null;
    }

    public synchronized void setCachedToken(TokenResult tokenResult) {
        String removedAccountIdPartition;
        Set<String> partitionNamesSet = this.getPartitionNames();
        if (!partitionNamesSet.contains(removedAccountIdPartition = Utils.removeAccountIdFromPartitionName(tokenResult.getPartition()))) {
            partitionNamesSet.add(removedAccountIdPartition);
            SharedPreferencesManager.putStringSet((String)"Data.partitions", partitionNamesSet);
        }
        String strTokenResult = Utils.getGson().toJson((Object)tokenResult);
        String encryptedTokenResult = CryptoUtils.getInstance((Context)this.mContext).encrypt(strTokenResult);
        SharedPreferencesManager.putString((String)("Data.partition." + removedAccountIdPartition), (String)encryptedTokenResult);
    }

    public synchronized void removeAllCachedTokens() {
        Set<String> partitionNamesSet = this.getPartitionNames();
        for (String partitionName : partitionNamesSet) {
            if (partitionName.equals("readonly")) continue;
            SharedPreferencesManager.remove((String)("Data.partition." + partitionName));
        }
        partitionNamesSet.clear();
        SharedPreferencesManager.putStringSet((String)"Data.partitions", partitionNamesSet);
        AppCenterLog.info((String)"AppCenterData", (String)"Removed all tokens in all partitions");
    }
}

