/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.crashes.ingestion.models;

import com.microsoft.appcenter.crashes.ingestion.models.Exception;
import com.microsoft.appcenter.ingestion.models.LogWithProperties;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public class HandledErrorLog
extends LogWithProperties {
    public static final String TYPE = "handledError";
    private static final String EXCEPTION = "exception";
    private UUID id;
    private Exception exception;

    public String getType() {
        return TYPE;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public void read(JSONObject object) throws JSONException {
        super.read(object);
        this.setId(UUID.fromString(object.getString("id")));
        if (object.has(EXCEPTION)) {
            JSONObject jException = object.getJSONObject(EXCEPTION);
            Exception exception = new Exception();
            exception.read(jException);
            this.setException(exception);
        }
    }

    public void write(JSONStringer writer) throws JSONException {
        super.write(writer);
        writer.key("id").value((Object)this.getId());
        if (this.getException() != null) {
            writer.key(EXCEPTION).object();
            this.exception.write(writer);
            writer.endObject();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HandledErrorLog errorLog = (HandledErrorLog)((Object)o);
        if (this.id != null ? !this.id.equals(errorLog.id) : errorLog.id != null) {
            return false;
        }
        return this.exception != null ? this.exception.equals(errorLog.exception) : errorLog.exception == null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.exception != null ? this.exception.hashCode() : 0);
        return result;
    }
}

