/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.crashes.ingestion.models;

import android.support.annotation.VisibleForTesting;
import android.util.Base64;
import com.microsoft.appcenter.ingestion.models.AbstractLog;
import com.microsoft.appcenter.ingestion.models.json.JSONUtils;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public class ErrorAttachmentLog
extends AbstractLog {
    public static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    public static final String TYPE = "errorAttachment";
    private static final String ERROR_ID = "errorId";
    private static final String CONTENT_TYPE = "contentType";
    private static final String FILE_NAME = "fileName";
    @VisibleForTesting
    static final Charset CHARSET = Charset.forName("UTF-8");
    @VisibleForTesting
    static final String DATA = "data";
    private UUID id;
    private UUID errorId;
    private String contentType;
    private String fileName;
    private byte[] data;

    public static ErrorAttachmentLog attachmentWithText(String text, String fileName) {
        if (text == null) {
            text = "";
        }
        return ErrorAttachmentLog.attachmentWithBinary(text.getBytes(CHARSET), fileName, CONTENT_TYPE_TEXT_PLAIN);
    }

    public static ErrorAttachmentLog attachmentWithBinary(byte[] data, String fileName, String contentType) {
        ErrorAttachmentLog attachmentLog = new ErrorAttachmentLog();
        attachmentLog.setData(data);
        attachmentLog.setFileName(fileName);
        attachmentLog.setContentType(contentType);
        return attachmentLog;
    }

    public String getType() {
        return TYPE;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public UUID getErrorId() {
        return this.errorId;
    }

    public void setErrorId(UUID errorId) {
        this.errorId = errorId;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public boolean isValid() {
        return this.getId() != null && this.getErrorId() != null && this.getContentType() != null && this.getData() != null;
    }

    public void read(JSONObject object) throws JSONException {
        super.read(object);
        this.setId(UUID.fromString(object.getString("id")));
        this.setErrorId(UUID.fromString(object.getString(ERROR_ID)));
        this.setContentType(object.getString(CONTENT_TYPE));
        this.setFileName(object.optString(FILE_NAME, null));
        try {
            this.setData(Base64.decode((String)object.getString(DATA), (int)0));
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(e.getMessage());
        }
    }

    public void write(JSONStringer writer) throws JSONException {
        super.write(writer);
        JSONUtils.write((JSONStringer)writer, (String)"id", (Object)this.getId());
        JSONUtils.write((JSONStringer)writer, (String)ERROR_ID, (Object)this.getErrorId());
        JSONUtils.write((JSONStringer)writer, (String)CONTENT_TYPE, (Object)this.getContentType());
        JSONUtils.write((JSONStringer)writer, (String)FILE_NAME, (Object)this.getFileName());
        JSONUtils.write((JSONStringer)writer, (String)DATA, (Object)Base64.encodeToString((byte[])this.getData(), (int)2));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ErrorAttachmentLog that = (ErrorAttachmentLog)((Object)o);
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.errorId != null ? !this.errorId.equals(that.errorId) : that.errorId != null) {
            return false;
        }
        if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) {
            return false;
        }
        if (this.fileName != null ? !this.fileName.equals(that.fileName) : that.fileName != null) {
            return false;
        }
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.errorId != null ? this.errorId.hashCode() : 0);
        result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
        result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }
}

