/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.crashes.ingestion.models;

import com.microsoft.appcenter.ingestion.models.AbstractLog;
import com.microsoft.appcenter.ingestion.models.json.JSONDateUtils;
import com.microsoft.appcenter.ingestion.models.json.JSONUtils;
import java.util.Date;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public abstract class AbstractErrorLog
extends AbstractLog {
    private static final String PROCESS_ID = "processId";
    private static final String PROCESS_NAME = "processName";
    private static final String PARENT_PROCESS_ID = "parentProcessId";
    private static final String PARENT_PROCESS_NAME = "parentProcessName";
    private static final String ERROR_THREAD_ID = "errorThreadId";
    private static final String ERROR_THREAD_NAME = "errorThreadName";
    private static final String FATAL = "fatal";
    private static final String APP_LAUNCH_TIMESTAMP = "appLaunchTimestamp";
    private static final String ARCHITECTURE = "architecture";
    private UUID id;
    private Integer processId;
    private String processName;
    private Integer parentProcessId;
    private String parentProcessName;
    private Long errorThreadId;
    private String errorThreadName;
    private Boolean fatal;
    private Date appLaunchTimestamp;
    private String architecture;

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Integer getProcessId() {
        return this.processId;
    }

    public void setProcessId(Integer processId) {
        this.processId = processId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public Integer getParentProcessId() {
        return this.parentProcessId;
    }

    public void setParentProcessId(Integer parentProcessId) {
        this.parentProcessId = parentProcessId;
    }

    public String getParentProcessName() {
        return this.parentProcessName;
    }

    public void setParentProcessName(String parentProcessName) {
        this.parentProcessName = parentProcessName;
    }

    public Long getErrorThreadId() {
        return this.errorThreadId;
    }

    public void setErrorThreadId(Long errorThreadId) {
        this.errorThreadId = errorThreadId;
    }

    public String getErrorThreadName() {
        return this.errorThreadName;
    }

    public void setErrorThreadName(String errorThreadName) {
        this.errorThreadName = errorThreadName;
    }

    public Boolean getFatal() {
        return this.fatal;
    }

    public void setFatal(Boolean fatal) {
        this.fatal = fatal;
    }

    public Date getAppLaunchTimestamp() {
        return this.appLaunchTimestamp;
    }

    public void setAppLaunchTimestamp(Date appLaunchTimestamp) {
        this.appLaunchTimestamp = appLaunchTimestamp;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public void read(JSONObject object) throws JSONException {
        super.read(object);
        this.setId(UUID.fromString(object.getString("id")));
        this.setProcessId(JSONUtils.readInteger((JSONObject)object, (String)PROCESS_ID));
        this.setProcessName(object.optString(PROCESS_NAME, null));
        this.setParentProcessId(JSONUtils.readInteger((JSONObject)object, (String)PARENT_PROCESS_ID));
        this.setParentProcessName(object.optString(PARENT_PROCESS_NAME, null));
        this.setErrorThreadId(JSONUtils.readLong((JSONObject)object, (String)ERROR_THREAD_ID));
        this.setErrorThreadName(object.optString(ERROR_THREAD_NAME, null));
        this.setFatal(JSONUtils.readBoolean((JSONObject)object, (String)FATAL));
        this.setAppLaunchTimestamp(JSONDateUtils.toDate((String)object.getString(APP_LAUNCH_TIMESTAMP)));
        this.setArchitecture(object.optString(ARCHITECTURE, null));
    }

    public void write(JSONStringer writer) throws JSONException {
        super.write(writer);
        JSONUtils.write((JSONStringer)writer, (String)"id", (Object)this.getId());
        JSONUtils.write((JSONStringer)writer, (String)PROCESS_ID, (Object)this.getProcessId());
        JSONUtils.write((JSONStringer)writer, (String)PROCESS_NAME, (Object)this.getProcessName());
        JSONUtils.write((JSONStringer)writer, (String)PARENT_PROCESS_ID, (Object)this.getParentProcessId());
        JSONUtils.write((JSONStringer)writer, (String)PARENT_PROCESS_NAME, (Object)this.getParentProcessName());
        JSONUtils.write((JSONStringer)writer, (String)ERROR_THREAD_ID, (Object)this.getErrorThreadId());
        JSONUtils.write((JSONStringer)writer, (String)ERROR_THREAD_NAME, (Object)this.getErrorThreadName());
        JSONUtils.write((JSONStringer)writer, (String)FATAL, (Object)this.getFatal());
        JSONUtils.write((JSONStringer)writer, (String)APP_LAUNCH_TIMESTAMP, (Object)JSONDateUtils.toString((Date)this.getAppLaunchTimestamp()));
        JSONUtils.write((JSONStringer)writer, (String)ARCHITECTURE, (Object)this.getArchitecture());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractErrorLog that = (AbstractErrorLog)((Object)o);
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.processId != null ? !this.processId.equals(that.processId) : that.processId != null) {
            return false;
        }
        if (this.processName != null ? !this.processName.equals(that.processName) : that.processName != null) {
            return false;
        }
        if (this.parentProcessId != null ? !this.parentProcessId.equals(that.parentProcessId) : that.parentProcessId != null) {
            return false;
        }
        if (this.parentProcessName != null ? !this.parentProcessName.equals(that.parentProcessName) : that.parentProcessName != null) {
            return false;
        }
        if (this.errorThreadId != null ? !this.errorThreadId.equals(that.errorThreadId) : that.errorThreadId != null) {
            return false;
        }
        if (this.errorThreadName != null ? !this.errorThreadName.equals(that.errorThreadName) : that.errorThreadName != null) {
            return false;
        }
        if (this.fatal != null ? !this.fatal.equals(that.fatal) : that.fatal != null) {
            return false;
        }
        if (this.appLaunchTimestamp != null ? !this.appLaunchTimestamp.equals(that.appLaunchTimestamp) : that.appLaunchTimestamp != null) {
            return false;
        }
        return this.architecture != null ? this.architecture.equals(that.architecture) : that.architecture == null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.processId != null ? this.processId.hashCode() : 0);
        result = 31 * result + (this.processName != null ? this.processName.hashCode() : 0);
        result = 31 * result + (this.parentProcessId != null ? this.parentProcessId.hashCode() : 0);
        result = 31 * result + (this.parentProcessName != null ? this.parentProcessName.hashCode() : 0);
        result = 31 * result + (this.errorThreadId != null ? this.errorThreadId.hashCode() : 0);
        result = 31 * result + (this.errorThreadName != null ? this.errorThreadName.hashCode() : 0);
        result = 31 * result + (this.fatal != null ? this.fatal.hashCode() : 0);
        result = 31 * result + (this.appLaunchTimestamp != null ? this.appLaunchTimestamp.hashCode() : 0);
        result = 31 * result + (this.architecture != null ? this.architecture.hashCode() : 0);
        return result;
    }
}

